unit Search;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TabNotBk, StdCtrls, Buttons, ExtCtrls, Grids, DBGrids,
  DBTables, DB;

type
  TTabbedNotebookDlg = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    OKBtn: TBitBtn;
    Panel1: TPanel;
    SSource: TDataSource;
    STable: TTable;
    QerySource: TDataSource;
    SQuery: TQuery;
    DBGrid1: TDBGrid;
    QueryBtn: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    NameEdit: TEdit;
    SurnameEdit: TEdit;
    BirthdayEdit: TEdit;
    AdresEdit: TEdit;
    NameCheckBox: TCheckBox;
    SurnameCheckBox: TCheckBox;
    BirthdayCheckBox: TCheckBox;
    AdresCheckBox: TCheckBox;
    PolRadioGroup: TRadioGroup;
    Status: TLabel;
    PredprRadioGroup: TRadioGroup;
    SQueryNUMBERID: TIntegerField;
    SQueryNATIONALITY: TSmallintField;
    SQueryTRADE_UNION: TSmallintField;
    SQueryNAME: TStringField;
    SQuerySURNAME: TStringField;
    SQueryBIRTHDAY: TStringField;
    SQueryPLACEOFBIRTH: TStringField;
    SQueryPARTY: TStringField;
    SQueryDIPLOM: TStringField;
    procedure OKBtnClick(Sender: TObject);
    procedure QueryBtnClick(Sender: TObject);
    procedure NameEditDblClick(Sender: TObject);
    procedure SurnameEditDblClick(Sender: TObject);
    procedure BirthdayEditDblClick(Sender: TObject);
    procedure AdresEditDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TabbedNotebookDlg: TTabbedNotebookDlg;

implementation

{$R *.DFM}

procedure TTabbedNotebookDlg.OKBtnClick(Sender: TObject);
begin
STable.Active := False;
Close;
end;


procedure TTabbedNotebookDlg.QueryBtnClick(Sender: TObject);
begin
SQuery.DisableControls;
SQuery.Close;
Screen.Cursor := crSQLWait;
TRY
   if (NameCheckBox.Checked) AND (NameEdit.text <> '')
   then {   }
    begin
     if Pos('"', NameEdit.text) <> 0 then
       MessageBox(0, '  <">    ,      e.',
                  '', MB_ICONINFORMATION+MB_TASKMODAL+MB_Ok) else
        SQuery.SQL.Strings[5] := Format(' AND (NAME LIKE "%s")', [NameEdit.text]);
   end else
     SQuery.SQL.Strings[5] := ' ';

   if (SurnameCheckBox.Checked) And (SurnameEdit.text <> '')
   then {    }
    begin
     if Pos('"', SurnameEdit.text) <> 0 then
       MessageBox(0, '  <">    ,      e.',
                  '', MB_ICONINFORMATION+MB_TASKMODAL+MB_Ok) else
      SQuery.SQL.Strings[6] := Format(' AND (SURNAME LIKE "%s")', [SurnameEdit.text]);
    end else
         SQuery.SQL.Strings[6] := ' ';

     if (BirthdayCheckBox.Checked) And (BirthdayEdit.text <> '')
   then {    }
    begin
     if Pos('"', BirthdayEdit.text) <> 0 then
       MessageBox(0, '  <">    ,      e.',
                  '', MB_ICONINFORMATION+MB_TASKMODAL+MB_Ok) else
       SQuery.SQL.Strings[7] := Format(' AND (BIRTHDAY LIKE "%s")', [BirthdayEdit.text]);
    end else
        SQuery.SQL.Strings[7] := ' ';

     if (AdresCheckBox.Checked) And (AdresEdit.text <> '')
   then {  }
    begin
     if Pos('"', AdresEdit.text) <> 0 then
       MessageBox(0, '  <">    ,      e.',
                  '', MB_ICONINFORMATION+MB_TASKMODAL+MB_Ok) else
       SQuery.SQL.Strings[8] := Format(' AND (ADRESS LIKE "%s")', [AdresEdit.text]);
    end else
         SQuery.SQL.Strings[8] := ' ';


    case PolRadioGroup.ItemIndex of
       0:   SQuery.SQL.Strings[4] := ' ';
       1: SQuery.SQL.Strings[4] :=Format('and (POL = 1)', [1]);
       2: SQuery.SQL.Strings[4] :=Format('and (POL = 2)', [2]);
       {0: Format('and (IAccound  = %S)', [IntToStr(IndxSQL)]);}
     end ;

    case PredprRadioGroup.ItemIndex of

       0: SQuery.SQL.Strings[9] :=Format('and (FACTORY = 1)', [1]);
       1: SQuery.SQL.Strings[9] :=Format('and (FACTORY = 2)', [2]);
       2:   SQuery.SQL.Strings[9] := ' ';
     end ;

SQuery.Open;

EXCEPT
END;

 SQuery.EnableControls;
  Screen.Cursor := crDefault;
  Status.Caption:='   : '+IntToStr( SQuery.RecordCount);
  TabbedNotebook1.PageIndex:=0;



end;

procedure TTabbedNotebookDlg.NameEditDblClick(Sender: TObject);
begin
If NameEdit.Text[1] <>'%' THEN
   NameEdit.Text:='%'+NameEdit.Text;
If NameEdit.Text[Length(NameEdit.Text)] <>'%' THEN
   NameEdit.Text:=NameEdit.Text+'%';

end;

procedure TTabbedNotebookDlg.SurnameEditDblClick(Sender: TObject);
begin
If SurnameEdit.Text[1] <>'%' THEN
   SurnameEdit.Text := '%' + SurnameEdit.Text;
If SurnameEdit.Text[Length(SurnameEdit.Text)] <>'%' THEN
   SurnameEdit.Text := SurnameEdit.Text+'%';

end;

procedure TTabbedNotebookDlg.BirthdayEditDblClick(Sender: TObject);
begin
If BirthdayEdit.Text[1] <>'%' THEN
   BirthdayEdit.Text:='%'+BirthdayEdit.Text;
If BirthdayEdit.Text[Length(BirthdayEdit.Text)] <>'%' THEN
   BirthdayEdit.Text:=BirthdayEdit.Text+'%';

end;

procedure TTabbedNotebookDlg.AdresEditDblClick(Sender: TObject);
begin
  If AdresEdit.Text[1] <>'%' THEN
   AdresEdit.Text:='%'+AdresEdit.Text;
If AdresEdit.Text[Length(AdresEdit.Text)] <>'%' THEN
   AdresEdit.Text:=AdresEdit.Text+'%';

end;




procedure TTabbedNotebookDlg.FormCreate(Sender: TObject);
begin
STable.Active := True;
TabbedNotebook1.PageIndex:=0;
WITH STable DO
  BEGIN
    FieldByName('NUMBER ID').DisplayLabel := '';
    FieldByName('NUMBER ID').DisplayWidth := 6;
    FieldByName('NAME').DisplayLabel := '';
    FieldByName('NAME').DisplayWidth := 15;
    FieldByName('SURNAME').DisplayLabel := ' ';
    FieldByName('SURNAME').DisplayWidth := 25;
    FieldByName('BIRTHDAY').DisplayLabel := ' ';
    FieldByName('BIRTHDAY').DisplayWidth := 13;
    FieldByName('PLACEOFBIRTH').DisplayLabel := ' ';
    FieldByName('PLACEOFBIRTH').DisplayWidth := 14;
    FieldByName('PASPORT').DisplayLabel := '(,)';
    FieldByName('PASPORT').DisplayWidth := 16;
    FieldByName('ADRESS').DisplayLabel := ' ';
    FieldByName('ADRESS').DisplayWidth := 40;
    FieldByName('PHONE').DisplayLabel := '';
    FieldByName('PHONE').DisplayWidth := 10;
    FieldByName('NATIONALITY').DisplayLabel := '';
    FieldByName('PARTY').Visible := False;
    FieldByName('TRADE_UNION').Visible := False;
    FieldByName('EDUCATION').Visible := False;
    FieldByName('NAME_ED').Visible := False;
    FieldByName('DATA').Visible := False;
    FieldByName('KIND_TEACH').Visible := False;
    FieldByName('SPETIALITY_DIP').Visible := False;
    FieldByName('QUALIFICATIO_DIP').Visible := False;
    FieldByName('DIPLOM').DisplayLabel := '';
    FieldByName('DIPLOM').DisplayWidth := 20;
    FieldByName('DATA_DIP').Visible := False;
    FieldByName('POST').DisplayLabel := ' ';
    FieldByName('TENGHT').DisplayLabel := '    ';
    FieldByName('TENGHT').DisplayWidth := 33;
    FieldByName('TOTAL TENGHT').DisplayLabel := '  ';
    FieldByName('TOTAL TENGHT').DisplayWidth := 17;
    FieldByName('UNBROKEN_REC').DisplayLabel := ' ';
    FieldByName('UNBROKEN_REC').DisplayWidth := 16;
    FieldByName('CASE UVOLN').DisplayLabel := ' ';
    FieldByName('UNBROKEN_REC').DisplayWidth := 20;
    FieldByName('DATA UVOLN').DisplayLabel := ' ';
    FieldByName('UNBROKEN_REC').DisplayWidth := 14;
    FieldByName('LASTPLACE').DisplayLabel := '  ';
    FieldByName('TOTAL TENGHT').DisplayWidth := 22;
    FieldByName('DATA_PASP').Visible := False;
    FieldByName('FAM_NAME1').Visible := False;
    FieldByName('FAM_SURNAME1').Visible := False;
    FieldByName('FAM_YEAR1').Visible := False;
    FieldByName('FAM_NAME2').Visible := False;
    FieldByName('FAM_SURNAME').Visible := False;
    FieldByName('FAM_YEAR2').Visible := False;
    FieldByName('FAM_NAME3').Visible := False;
    FieldByName('FAM_SURNAME3').Visible := False;
    FieldByName('FAM_YEAR3').Visible := False;
    FieldByName('FAM_NAME4').Visible := False;
    FieldByName('FAM_SURNAME4').Visible := False;
    FieldByName('FAM_YEAR4').Visible := False;
    END;


end;

procedure TTabbedNotebookDlg.FormActivate(Sender: TObject);
begin
STable.Active := True;
end;

end.
 