unit Post;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Grids, DBGrids, DB, DBTables, StdCtrls, Buttons;

type
  TPostForm = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    NumEdit: TEdit;
    PostEdit: TEdit;
    PostSource: TDataSource;
    PostTable: TTable;
    DBGrid1: TDBGrid;
    AddBtn: TSpeedButton;
    CancelBtn: TSpeedButton;
    RefreshBtn: TSpeedButton;
    CloseBtn: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    s : String;
  public
    { Public declarations }
  end;

var
  PostForm: TPostForm;

implementation

{$R *.DFM}



procedure TPostForm.FormCreate(Sender: TObject);
begin
PostTable.Active := True;
   WITH  PostTable DO
    BEGIN
     FieldByName('NUM').DisplayLabel := '';
     FieldByName('NUM').DisplayWidth := 5;
     FieldByName('POST').DisplayLabel := '';
     FieldByName('POST').DisplayWidth := 35;
    END;

end;

procedure TPostForm.AddBtnClick(Sender: TObject);
begin
IF (Length(NumEdit.Text)=0)AND
   (Length(PostEdit.Text)=0)
THEN
   MessageDlg('   !', mtError, [mbCancel], 0)
ELSE
  WITH PostTable DO
    BEGIN
     s :=  NumEdit.Text;
     IndexFieldNames := 'NUM';
     IF FindKey([NumEdit.Text]) THEN
        MessageDlg(' !', mtError, [mbCancel], 0)
     ELSE
     InsertRecord([NumEdit.Text, PostEdit.Text] );

 {  }
 NumEdit.Text :='';
 PostEdit.Text :='';
 END;

end;

procedure TPostForm.CancelBtnClick(Sender: TObject);
begin
 NumEdit.Text :='';
 PostEdit.Text :='';

end;

procedure TPostForm.RefreshBtnClick(Sender: TObject);
begin
 WITH PostTable DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([s]) THEN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;

end;

procedure TPostForm.CloseBtnClick(Sender: TObject);
begin
PostTable.Active := False;
Close;
end;

procedure TPostForm.DBGrid1DblClick(Sender: TObject);
begin
WITH DBGrid1.SelectedField DO
 BEGIN
 WITH PostTable DO
    BEGIN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;
END;
end;

procedure TPostForm.FormActivate(Sender: TObject);
begin
PostTable.Active := True;
end;

end.
