unit Godnost;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls, Grids, DBGrids, Buttons, ExtCtrls;

type
  TGodnForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    CloseBtn: TSpeedButton;
    AddBtn: TSpeedButton;
    CancelBtn: TSpeedButton;
    RefreshBtn: TSpeedButton;
    DBGrid1: TDBGrid;
    NumEdit: TEdit;
    TextEdit: TEdit;
    GodnSource1: TDataSource;
    GodnTable1: TTable;
    Bevel1: TBevel;
    Bevel2: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    s : String ;
  public
    { Public declarations }
  end;

var
  GodnForm: TGodnForm;

implementation

{$R *.DFM}

procedure TGodnForm.FormCreate(Sender: TObject);
begin
GodnTable1.Active := True;
WITH GodnTable1 DO
BEGIN
  FieldByName('NUM').DisplayLabel := '';
  FieldByName('GODNOST').DisplayLabel := '   ';
  FieldByName('NUM').DisplayWidth := 5;
  FieldByName('GODNOST').DisplayWidth := 50;
end;

end;

procedure TGodnForm.AddBtnClick(Sender: TObject);
begin
IF (Length(NumEdit.Text)=0)AND
   (Length(TextEdit.Text)=0)
THEN
   MessageDlg('   !', mtError, [mbCancel], 0)
ELSE
  WITH GodnTable1 DO
    BEGIN
      s := NumEdit.Text;
     IndexFieldNames := 'NUM';
     IF FindKey([NumEdit.Text]) THEN
        MessageDlg(' !', mtError, [mbCancel], 0)
     ELSE
     InsertRecord([NumEdit.Text, TextEdit.Text] );

 {  }
 NumEdit.Text :='';
 TextEdit.Text :='';
 END;

end;

procedure TGodnForm.CancelBtnClick(Sender: TObject);
begin
 NumEdit.Text :='';
 TextEdit.Text :='';
end;

procedure TGodnForm.RefreshBtnClick(Sender: TObject);
begin
  WITH GodnTable1 DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([s]) THEN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{   }
END;


end;

procedure TGodnForm.CloseBtnClick(Sender: TObject);
begin
GodnTable1.Active := False;
Close;

end;

procedure TGodnForm.FormActivate(Sender: TObject);
begin
GodnTable1.Active := True;
WITH GodnTable1 DO
BEGIN
  FieldByName('NUM').DisplayLabel := '';
  FieldByName('GODNOST').DisplayLabel := '   ';
  FieldByName('NUM').DisplayWidth := 5;
  FieldByName('GODNOST').DisplayWidth := 50;
end;

end;

end.
