unit Max;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TabNotBk, StdCtrls, Buttons, Grids, DBGrids, DBTables, DB,
  Add ,Del;

type
  TTabbedNotebookDlg = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    SQLBtn: TSpeedButton;
    BaseSource: TDataSource;
    BaseTable: TTable;
    MaxQuery: TQuery;
    QuerySource: TDataSource;
    SQLGrid: TDBGrid;
    BaseGrid: TDBGrid;
    AddBtn: TSpeedButton;
    DelBtn: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    NameEdit: TEdit;
    SurnameEdit: TEdit;
    BirthdayEdit: TEdit;
    NameCheckBox: TCheckBox;
    SurnameCheckBox: TCheckBox;
    BirthdayCheckBox: TCheckBox;
    Status: TLabel;
    EndBtn: TSpeedButton;
    Label4: TLabel;
    HandEdit: TEdit;
    Label5: TLabel;
    NEdit: TEdit;
    BaseTableNumberID: TSmallintField;
    BaseTableName: TStringField;
    BaseTableSurname: TStringField;
    BaseTableBirtday: TStringField;
    BaseTablePasport: TStringField;
    BaseTablePost: TStringField;
    BaseTableAdress: TStringField;
    BaseTablePhone: TStringField;
    BaseTableNachisl: TFloatField;
    BaseTableVid: TFloatField;
    procedure EndBtnClick(Sender: TObject);
    procedure NameEditDblClick(Sender: TObject);
    procedure SurnameEditDblClick(Sender: TObject);
    procedure BirthdayEditDblClick(Sender: TObject);
    procedure SQLBtnClick(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TabbedNotebookDlg: TTabbedNotebookDlg;

implementation

{$R *.DFM}

procedure TTabbedNotebookDlg.EndBtnClick(Sender: TObject);
begin
Close;
end;

procedure TTabbedNotebookDlg.NameEditDblClick(Sender: TObject);
begin
If NameEdit.Text[1] <>'%' THEN
   NameEdit.Text:='%'+NameEdit.Text;
If NameEdit.Text[Length(NameEdit.Text)] <>'%' THEN
   NameEdit.Text:=NameEdit.Text+'%';

end;

procedure TTabbedNotebookDlg.SurnameEditDblClick(Sender: TObject);
begin
 If SurnameEdit.Text[1] <>'%' THEN
    SurnameEdit.Text := '%' + SurnameEdit.Text;
 If SurnameEdit.Text[Length(SurnameEdit.Text)] <>'%' THEN
    SurnameEdit.Text := SurnameEdit.Text+'%';

end;

procedure TTabbedNotebookDlg.BirthdayEditDblClick(Sender: TObject);
begin
 If BirthdayEdit.Text[1] <>'%' THEN
    BirthdayEdit.Text:='%'+BirthdayEdit.Text;
 If BirthdayEdit.Text[Length(BirthdayEdit.Text)] <>'%' THEN
    BirthdayEdit.Text:=BirthdayEdit.Text+'%';

end;

procedure TTabbedNotebookDlg.SQLBtnClick(Sender: TObject);
begin
MaxQuery.DisableControls;
MaxQuery.Close;
Screen.Cursor := crSQLWait;
TRY
   if (NameCheckBox.Checked) AND (NameEdit.text <> '')
   then {   }
    begin
     if Pos('"', NameEdit.text) <> 0 then
       MessageBox(0, '  <">    ,      e.',
                  '', MB_ICONINFORMATION+MB_TASKMODAL+MB_Ok) else
        MaxQuery.SQL.Strings[4] := Format(' AND (NAME LIKE "%s")', [NameEdit.text]);
   end else
     MaxQuery.SQL.Strings[4] := ' ';

   if (SurnameCheckBox.Checked) And (SurnameEdit.text <> '')
   then {    }
    begin
     if Pos('"', SurnameEdit.text) <> 0 then
       MessageBox(0, '  <">    ,      e.',
                  '', MB_ICONINFORMATION+MB_TASKMODAL+MB_Ok) else
     MaxQuery.SQL.Strings[5] := Format(' AND (SURNAME LIKE "%s")', [SurnameEdit.text]);
    end else
         MaxQuery.SQL.Strings[5] := ' ';

     if (BirthdayCheckBox.Checked) And (BirthdayEdit.text <> '')
   then {    }
    begin
     if Pos('"', BirthdayEdit.text) <> 0 then
       MessageBox(0, '  <">    ,      e.',
                  '', MB_ICONINFORMATION+MB_TASKMODAL+MB_Ok) else
     MaxQuery.SQL.Strings[6] := Format(' AND (BIRTHDAY LIKE "%s")', [BirthdayEdit.text]);
    end else
        MaxQuery.SQL.Strings[6] := ' ';

 {    if (AdresCheckBox.Checked) And (AdresEdit.text <> '')
   then {  
    begin
     if Pos('"', AdresEdit.text) <> 0 then
       MessageBox(0, '  <">    ,      e.',
                  '', MB_ICONINFORMATION+MB_TASKMODAL+MB_Ok) else
      MaxQuery.SQL.Strings[7] := Format(' AND (ADRESS LIKE "%s")', [AdresEdit.text]);
    end else
        MaxQuery.SQL.Strings[7] := ' ';}



MaxQuery.Open;

EXCEPT
END;

MaxQuery.EnableControls;
  Screen.Cursor := crDefault;
  Status.Caption:='   : '+IntToStr( MaxQuery.RecordCount);
  TabbedNotebook1.PageIndex:=0;




end;

procedure TTabbedNotebookDlg.AddBtnClick(Sender: TObject);
begin
AddForm.Show;
end;

procedure TTabbedNotebookDlg.DelBtnClick(Sender: TObject);
begin
DelForm.Show;
end;


procedure TTabbedNotebookDlg.FormActivate(Sender: TObject);
begin
  TabbedNotebook1.PageIndex:=2;
  
end;

end.
 