/* File prim.c   p p䮢        6  .H.  1996. */
/* p ᪠ ⮢ 쭮   襭 p */
/* .p, 1957 .                                              */

#include <stdio.h>
#include <stdlib.h>
#include <float.h>

int  load_matrix(int n, double* weigh);	/*  p ᮢ */
int  prim(int n, double* weigh);	/* p ᪠    */
void print(int n, double* weigh);	/* 뢮 p   */

void main(void){
    int n=0,ret=0;
    double *weigh;
    printf("\np ᪠ ⮢ 쭮   襭 p.\n");
    printf(".p, 1957 .\n");
    printf("\n ⢮ p設..");
    scanf("%d",&n);
    if (n <= 1){
	printf("\n⢮ p設    !\n");
	exit(1);
    }
    weigh=malloc(sizeof(double)*n*n);
    if (weigh == NULL){
	printf("\nH筮   p㧪 ᨢ!\n");
	exit(2);
    }
    ret=load_matrix(n,weigh);
    if (ret != 0){
	printf("\n訡  !\n");
	exit(5);
    }
    ret=prim(n,weigh);
    if (ret != 0){
	switch (ret){
	    case 1 :
		printf("\np   易!\n");
		exit(3);
	    case 2 :
		printf("\nH筮   p!\n");
		exit(4);
	}
    }
    print(n,weigh);
    free(weigh);
}

int load_matrix(int n, double* weigh){
    int i,j,k;
    double tmp;
    for (i=0; i < n; i++){
	for (j=0; j < n; j++){
	    weigh[n*i+j]=(-1);
	}
    }
    printf("\n ᫥⥫쭮  pp  㪠 p設  -1  ᬥ.");
    for (i=0; i < n; i++){
	for (j=i+1; j < n; j++){
	    printf("\np設 %d  %d ",i+1,j+1);
	    k=scanf("%lf",&tmp);
	    if (k != 1){return(1);}
	    weigh[i*n+j]=tmp;
	}
    }
    return(0);
}

int prim(int n, double* weigh){
    int i,j,k,l,m,flag;
    int* index;
    double tmp;

    index=calloc(sizeof(int),n);
    if (index == NULL){return(2);}
    index[0]=1;
    for (k=0; k < (n-1); k++){
	for (i=0,flag=0,tmp=DBL_MAX; i < n; i++){
	    for (j=i+1; j < n; j++){
		if ((weigh[i*n+j] < tmp)&&
		    (weigh[i*n+j] >= 0)&&
		    (weigh[j*n+i] == (-1))&&
		    (index[i]*index[j] == 0)&&
		    (index[i]+index[j] == 1)){
		    flag=1;
		    tmp=weigh[i*n+j];
		    l=i;
		    m=j;
		}
	    }
	}
	if (flag == 1){
	    weigh[m*n+l]=tmp;
	    index[m]=1;
	    index[l]=1;
	}
    }
    for (i=0; i < n; i++){
	if (index[i] == 0)
	return(1);
    }
    free(index);
    return(0);
}

void print(int n, double* weigh){
    int i,j;
    double tmp=0.0;
    printf("\n⮢ 쭮 :");
    for (i=0; i < n; i++){
	printf("\n");
	for (j=(i+1); j < n; j++){
	    if (weigh[j*n+i] != (-1)){
		printf(" weigh[%d,%d]=%6.2f",i+1,j+1,weigh[j*n+i]);
		tmp+=weigh[j*n+i];
	    }
	}
    }
    printf("\n  p: %6.2f\n",tmp);
}