
CREATE TABLE ACTIVITY
      (ACTIVITY_ID              NUMBER(7) NOT NULL,
       ACTIVITY_CHAR            VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKACTIVITY
  ON ACTIVITY
(
       ACTIVITY_ID                    ASC
);


ALTER TABLE ACTIVITY
ADD  (  PRIMARY KEY (ACTIVITY_ID) ) ;


CREATE TABLE BUILDING
      (BUILDING_ID              NUMBER(7) NOT NULL,
       BUILDING_CHAR            VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKBUILDING
  ON BUILDING
(
       BUILDING_ID                    ASC
);


ALTER TABLE BUILDING
ADD  (  PRIMARY KEY (BUILDING_ID) ) ;


CREATE TABLE BUILDINGOB
      (OBJECT_ID                NUMBER(9) NOT NULL,
       BUILDING_ID              NUMBER(7) NOT NULL,
       BUILDINGNUM              NUMBER(9) NULL,
       NAMEADD_ID               NUMBER(7) NOT NULL,
       DATEADD                  DATE NOT NULL,
       NAMEINS_ID               NUMBER(7) NOT NULL,
       DATEINS                  DATE NOT NULL,
       PRIM                     VARCHAR2(100) NULL
);

CREATE UNIQUE INDEX IPKBUILDINGOB
  ON BUILDINGOB
(
       OBJECT_ID                      ASC,
       BUILDING_ID                    ASC
);

CREATE INDEX IFKOBBUILDINGOB
  ON BUILDINGOB
(
       OBJECT_ID                      ASC
);

CREATE INDEX IFKBUBUILDINGOB
  ON BUILDINGOB
(
       BUILDING_ID                    ASC
);


ALTER TABLE BUILDINGOB
ADD  (  PRIMARY KEY (OBJECT_ID, BUILDING_ID) ) ;


CREATE TABLE CATEGORY
      (CATEGORY_ID              NUMBER(7) NOT NULL,
       CATEGORY_TYPE            NUMBER(1) NOT NULL,
       CATEGORY_CHAR            VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKCATEGORY
  ON CATEGORY
(
       CATEGORY_ID                    ASC
);


ALTER TABLE CATEGORY
ADD  (  PRIMARY KEY (CATEGORY_ID) ) ;


CREATE TABLE CATTEMA
      (TEMA_ID                  NUMBER(7) NOT NULL,
       CATEGORY_ID              NUMBER(7) NOT NULL,
       CATTEMANUM               NUMBER(4) NULL,
       NAMEADD_ID               NUMBER(7) NOT NULL,
       DATEADD                  DATE NOT NULL,
       NAMEINS_ID               NUMBER(7) NOT NULL,
       DATEINS                  DATE NOT NULL,
       PRIM                     VARCHAR2(100) NULL
);

CREATE UNIQUE INDEX IPKCATTEMA
  ON CATTEMA
(
       TEMA_ID                        ASC,
       CATEGORY_ID                    ASC
);

CREATE INDEX IFKTECATTEMA
  ON CATTEMA
(
       TEMA_ID                        ASC
);

CREATE INDEX IFKCACATTEMA
  ON CATTEMA
(
       CATEGORY_ID                    ASC
);


ALTER TABLE CATTEMA
ADD  (  PRIMARY KEY (TEMA_ID, CATEGORY_ID) ) ;


CREATE TABLE DEPARTAMENT
      (DEPARTAMENT_ID           NUMBER(7) NOT NULL,
       DEPARTAMENT_CHAR         VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKDEPARTAMENT
  ON DEPARTAMENT
(
       DEPARTAMENT_ID                 ASC
);


ALTER TABLE DEPARTAMENT
ADD  (  PRIMARY KEY (DEPARTAMENT_ID) ) ;


CREATE TABLE FORMIROV
      (FORMIROV_ID              NUMBER(7) NOT NULL,
       FORMIROV_CHAR            VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKFORMIROV
  ON FORMIROV
(
       FORMIROV_ID                    ASC
);


ALTER TABLE FORMIROV
ADD  (  PRIMARY KEY (FORMIROV_ID) ) ;


CREATE TABLE FORMIROVOB
      (FORMIROV_ID              NUMBER(7) NOT NULL,
       OBJECT_ID                NUMBER(9) NOT NULL,
       READY_ID                 NUMBER(7) NOT NULL,
       FORMIROVNUM              NUMBER(9) NULL,
       PEOPLENUM                NUMBER(9) NULL,
       NAMEADD_ID               NUMBER(7) NOT NULL,
       DATEADD                  DATE NOT NULL,
       NAMEINS_ID               NUMBER(7) NOT NULL,
       DATEINS                  DATE NOT NULL,
       PRIM                     VARCHAR2(100) NULL
);

CREATE UNIQUE INDEX IPKFORMIROVOB
  ON FORMIROVOB
(
       FORMIROV_ID                    ASC,
       OBJECT_ID                      ASC
);

CREATE INDEX IFKFOFORMIROVOB
  ON FORMIROVOB
(
       FORMIROV_ID                    ASC
);

CREATE INDEX IFKOBFORMIROVOB
  ON FORMIROVOB
(
       OBJECT_ID                      ASC
);

CREATE INDEX IFKREFORMIROVOB
  ON FORMIROVOB
(
       READY_ID                       ASC
);


ALTER TABLE FORMIROVOB
ADD  (  PRIMARY KEY (FORMIROV_ID, OBJECT_ID) ) ;


CREATE TABLE GOBASEUSER
      (GOBASEUSER_ID            NUMBER(7) NOT NULL,
       NAME                     VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKGOBASEUSER
  ON GOBASEUSER
(
       GOBASEUSER_ID                  ASC
);


ALTER TABLE GOBASEUSER
ADD  (  PRIMARY KEY (GOBASEUSER_ID) ) ;


CREATE TABLE MATERIAL
      (MATERIAL_ID              NUMBER(7) NOT NULL,
       MATERIAL_CHAR            VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKMATERIAL
  ON MATERIAL
(
       MATERIAL_ID                    ASC
);


ALTER TABLE MATERIAL
ADD  (  PRIMARY KEY (MATERIAL_ID) ) ;


CREATE TABLE MATERIALOB
      (OBJECT_ID                NUMBER(9) NOT NULL,
       MATERIAL_ID              NUMBER(7) NOT NULL,
       MATERIALNUM              NUMBER(9) NULL,
       NAMEADD_ID               NUMBER(7) NOT NULL,
       DATEADD                  DATE NOT NULL,
       NAMEINS_ID               NUMBER(7) NOT NULL,
       DATEINS                  DATE NOT NULL,
       PRIM                     VARCHAR2(100) NULL
);

CREATE UNIQUE INDEX IPKMATERIALOB
  ON MATERIALOB
(
       OBJECT_ID                      ASC,
       MATERIAL_ID                    ASC
);

CREATE INDEX IFKOBMATERIALOB
  ON MATERIALOB
(
       OBJECT_ID                      ASC
);

CREATE INDEX IFKMAMATERIALOB
  ON MATERIALOB
(
       MATERIAL_ID                    ASC
);


ALTER TABLE MATERIALOB
ADD  (  PRIMARY KEY (OBJECT_ID, MATERIAL_ID) ) ;


CREATE TABLE MATTEH
      (MATTEH_ID                NUMBER(7) NOT NULL,
       SERVIS_ID                NUMBER(7) NOT NULL,
       MATTEH_CHAR              VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKMATTEH
  ON MATTEH
(
       MATTEH_ID                      ASC
);

CREATE INDEX IFKSEMATTEH
  ON MATTEH
(
       SERVIS_ID                      ASC
);


ALTER TABLE MATTEH
ADD  (  PRIMARY KEY (MATTEH_ID) ) ;


CREATE TABLE MATTEHOB
      (OBJECT_ID                NUMBER(9) NOT NULL,
       MATTEH_ID                NUMBER(7) NOT NULL,
       MATTEHNUM                NUMBER(9) NULL,
       NAMEADD_ID               NUMBER(7) NOT NULL,
       DATEADD                  DATE NOT NULL,
       NAMEINS_ID               NUMBER(7) NOT NULL,
       DATEINS                  DATE NOT NULL,
       PRIM                     VARCHAR2(100) NULL
);

CREATE UNIQUE INDEX IPKMATTEHOB
  ON MATTEHOB
(
       OBJECT_ID                      ASC,
       MATTEH_ID                      ASC
);

CREATE INDEX IFKMAMATTEHOB
  ON MATTEHOB
(
       MATTEH_ID                      ASC
);

CREATE INDEX IFKOBMATTEHOB
  ON MATTEHOB
(
       OBJECT_ID                      ASC
);


ALTER TABLE MATTEHOB
ADD  (  PRIMARY KEY (OBJECT_ID, MATTEH_ID) ) ;


CREATE TABLE OBECONOM
      (OBJECT_ID                NUMBER(9) NOT NULL,
       OBJECTNO                 NUMBER(7) NOT NULL,
       POSTGO_ID                NUMBER(7) NOT NULL,
       POST_ID                  NUMBER(7) NOT NULL,
       DEPARTAMENT_ID           NUMBER(7) NOT NULL,
       RISK_ID                  NUMBER(7) NOT NULL,
       PROPERTY_ID              NUMBER(7) NOT NULL,
       ACTIVITY_ID              NUMBER(7) NOT NULL,
       REGION_ID                NUMBER(7) NOT NULL,
       PECULIAR_ID              NUMBER(7) NOT NULL,
       GLAVOBJECT_ID            NUMBER(7) NOT NULL,
       OBJECTNAME               VARCHAR2(100) NULL,
       ADDRESS_IND              CHAR(6) NULL,
       TOWN_ID                  NUMBER(9) NULL,
       ADDRESS_CHAR             VARCHAR2(150) NULL,
       WORKNUMBER               NUMBER(7) NULL,
       NRSM                     NUMBER(7) NULL,
       NRSV                     NUMBER(7) NULL,
       DIRECTIONNAME            VARCHAR2(50) NULL,
       DIRECTIONWTEL            CHAR(7) NULL,
       DIRECTIONHTEL            CHAR(7) NULL,
       ZAMNAME                  VARCHAR2(50) NULL,
       ZAMWTEL                  CHAR(7) NULL,
       ZAMHTEL                  CHAR(7) NULL,
       COMANDGONAME             VARCHAR2(50) NULL,
       COMANDGOWTEL             CHAR(7) NULL,
       COMANDGOHTEL             CHAR(7) NULL,
       P1NAME                   VARCHAR2(50) NULL,
       P1WTEL                   CHAR(7) NULL,
       P1HTEL                   CHAR(7) NULL,
       P2NAME                   VARCHAR2(50) NULL,
       P2WTEL                   CHAR(7) NULL,
       P2HTEL                   CHAR(7) NULL,
       P3NAME                   VARCHAR2(50) NULL,
       P3WTEL                   CHAR(7) NULL,
       P3HTEL                   CHAR(7) NULL,
       DUTYTEL                  CHAR(7) NULL,
       DUTY2TEL                 CHAR(7) NULL,
       FAXTEL                   CHAR(7) NULL,
       MODEMTEL                 CHAR(7) NULL,
       NAMEADD_ID               NUMBER(7) NOT NULL,
       DATEADD                  DATE NOT NULL,
       NAMEINS_ID               NUMBER(7) NOT NULL,
       DATEINS                  DATE NOT NULL,
       PRIM                     VARCHAR2(200) NULL
);

CREATE UNIQUE INDEX IPKOBECONOM
  ON OBECONOM
(
       OBJECT_ID                      ASC
);

CREATE INDEX IFKPEOBECONOM
  ON OBECONOM
(
       PECULIAR_ID                    ASC
);

CREATE INDEX IFKRIOBECONOM
  ON OBECONOM
(
       RISK_ID                        ASC
);

CREATE INDEX IFKPROBECONOM
  ON OBECONOM
(
       PROPERTY_ID                    ASC
);

CREATE INDEX IFKACOBECONOM
  ON OBECONOM
(
       ACTIVITY_ID                    ASC
);

CREATE INDEX IFKREOBECONOM
  ON OBECONOM
(
       REGION_ID                      ASC
);

CREATE INDEX IFKDEOBECONOM
  ON OBECONOM
(
       DEPARTAMENT_ID                 ASC
);

CREATE INDEX IFKPOOBECONOM
  ON OBECONOM
(
       POST_ID                        ASC
);

CREATE INDEX IFKPGOBECONOM
  ON OBECONOM
(
       POSTGO_ID                      ASC
);


ALTER TABLE OBECONOM
ADD  (  PRIMARY KEY (OBJECT_ID) ) ;


CREATE TABLE ORAUSER
      (ORAUSER_ID               INTEGER NOT NULL,
       GOBASEUSER_ID            NUMBER(7) NOT NULL
);

CREATE UNIQUE INDEX IPKORAUSER
  ON ORAUSER
(
       ORAUSER_ID                     ASC
);

CREATE INDEX IFKGORAUSER
  ON ORAUSER
(
       GOBASEUSER_ID                  ASC
);


ALTER TABLE ORAUSER
ADD  (  PRIMARY KEY (ORAUSER_ID) ) ;


CREATE TABLE PECULIAR
      (PECULIAR_ID              NUMBER(7) NOT NULL,
       PECULIAR_CHAR            VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKPECULIAR
  ON PECULIAR
(
       PECULIAR_ID                    ASC
);


ALTER TABLE PECULIAR
ADD  (  PRIMARY KEY (PECULIAR_ID) ) ;


CREATE TABLE POST
      (POST_ID                  NUMBER(7) NOT NULL,
       POST_CHAR                VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKPOST
  ON POST
(
       POST_ID                        ASC
);


ALTER TABLE POST
ADD  (  PRIMARY KEY (POST_ID) ) ;


CREATE TABLE POSTGO
      (POSTGO_ID                NUMBER(7) NOT NULL,
       POSTGO_CHAR              VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKPOSTGO
  ON POSTGO
(
       POSTGO_ID                      ASC
);


ALTER TABLE POSTGO
ADD  (  PRIMARY KEY (POSTGO_ID) ) ;


CREATE TABLE PROPERTY
      (PROPERTY_ID              NUMBER(7) NOT NULL,
       PROPERTY_CHAR            VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKPROPERTY
  ON PROPERTY
(
       PROPERTY_ID                    ASC
);


ALTER TABLE PROPERTY
ADD  (  PRIMARY KEY (PROPERTY_ID) ) ;


CREATE TABLE READY
      (READY_ID                 NUMBER(7) NOT NULL,
       READY_CHAR               VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKREADY
  ON READY
(
       READY_ID                       ASC
);


ALTER TABLE READY
ADD  (  PRIMARY KEY (READY_ID) ) ;


CREATE TABLE REGION
      (REGION_ID                NUMBER(7) NOT NULL,
       REGION_CHAR              VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKREGION
  ON REGION
(
       REGION_ID                      ASC
);


ALTER TABLE REGION
ADD  (  PRIMARY KEY (REGION_ID) ) ;


CREATE TABLE RISK
      (RISK_ID                  NUMBER(7) NOT NULL,
       RISK_CHAR                VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKRISK
  ON RISK
(
       RISK_ID                        ASC
);


ALTER TABLE RISK
ADD  (  PRIMARY KEY (RISK_ID) ) ;


CREATE TABLE SERVIS
      (SERVIS_ID                NUMBER(7) NOT NULL,
       SERVIS_CHAR              VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKSERVIS
  ON SERVIS
(
       SERVIS_ID                      ASC
);


ALTER TABLE SERVIS
ADD  (  PRIMARY KEY (SERVIS_ID) ) ;


CREATE TABLE SPOST
      (SPOST_ID                 NUMBER(7) NOT NULL,
       SPOST_CHAR               VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKSPOST
  ON SPOST
(
       SPOST_ID                       ASC
);


ALTER TABLE SPOST
ADD  (  PRIMARY KEY (SPOST_ID) ) ;


CREATE TABLE STUDY
      (STUDY_ID                 NUMBER(9) NOT NULL,
       OBJECT_ID                NUMBER(9) NOT NULL,
       SPOST_ID                 NUMBER(7) NOT NULL,
       CATEGORY_ID              NUMBER(7) NOT NULL,
       NAME                     VARCHAR2(50) NULL,
       WORKTEL                  CHAR(7) NULL,
       LASTDATE                 DATE NOT NULL,
       NEXTDATE                 DATE NOT NULL,
       NAMEADD_ID               NUMBER(7) NOT NULL,
       DATEADD                  DATE NOT NULL,
       NAMEINS_ID               NUMBER(7) NOT NULL,
       DATEINS                  DATE NOT NULL,
       PRIM                     VARCHAR2(200) NULL
);

CREATE UNIQUE INDEX IPKSTUDY
  ON STUDY
(
       STUDY_ID                       ASC
);

CREATE INDEX IFKCASTUDY
  ON STUDY
(
       CATEGORY_ID                    ASC
);

CREATE INDEX IFKOBSTUDY
  ON STUDY
(
       OBJECT_ID                      ASC
);

CREATE INDEX IFKSPSTUDY
  ON STUDY
(
       SPOST_ID                       ASC
);


ALTER TABLE STUDY
ADD  (  PRIMARY KEY (STUDY_ID) ) ;


CREATE TABLE TEHNICA
      (TEHNICA_ID               NUMBER(7) NOT NULL,
       TEHNICA_CHAR             VARCHAR2(50) NULL
);

CREATE UNIQUE INDEX IPKTEHNICA
  ON TEHNICA
(
       TEHNICA_ID                     ASC
);


ALTER TABLE TEHNICA
ADD  (  PRIMARY KEY (TEHNICA_ID) ) ;


CREATE TABLE TEHNICAOB
      (OBJECT_ID                NUMBER(9) NOT NULL,
       TEHNICA_ID               NUMBER(7) NOT NULL,
       TEHNICANUM               NUMBER(9) NULL,
       NAMEADD_ID               NUMBER(7) NOT NULL,
       DATEADD                  DATE NOT NULL,
       NAMEINS_ID               NUMBER(7) NOT NULL,
       DATEINS                  DATE NOT NULL,
       PRIM                     VARCHAR2(100) NULL
);

CREATE UNIQUE INDEX IPKTEHNICOB
  ON TEHNICAOB
(
       OBJECT_ID                      ASC,
       TEHNICA_ID                     ASC
);

CREATE INDEX IFKTETEHNICAOB
  ON TEHNICAOB
(
       TEHNICA_ID                     ASC
);

CREATE INDEX IFKOBTEHNICAOB
  ON TEHNICAOB
(
       OBJECT_ID                      ASC
);


ALTER TABLE TEHNICAOB
ADD  (  PRIMARY KEY (OBJECT_ID, TEHNICA_ID) ) ;


CREATE TABLE TEMA
      (TEMA_ID                  NUMBER(7) NOT NULL,
       TEMA_CHAR                VARCHAR2(255) NULL
);

CREATE UNIQUE INDEX IPKTEMA
  ON TEMA
(
       TEMA_ID                        ASC
);


ALTER TABLE TEMA
ADD  (  PRIMARY KEY (TEMA_ID) ) ;


ALTER TABLE BUILDINGOB
ADD  (  FOREIGN KEY  (BUILDING_ID)
               REFERENCES BUILDING ) ;


ALTER TABLE BUILDINGOB
ADD  (  FOREIGN KEY  (OBJECT_ID)
               REFERENCES OBECONOM ) ;


ALTER TABLE CATTEMA
ADD  (  FOREIGN KEY  (CATEGORY_ID)
               REFERENCES CATEGORY ) ;


ALTER TABLE CATTEMA
ADD  (  FOREIGN KEY  (TEMA_ID)
               REFERENCES TEMA ) ;


ALTER TABLE FORMIROVOB
ADD  (  FOREIGN KEY  (READY_ID)
               REFERENCES READY ) ;


ALTER TABLE FORMIROVOB
ADD  (  FOREIGN KEY  (OBJECT_ID)
               REFERENCES OBECONOM ) ;


ALTER TABLE FORMIROVOB
ADD  (  FOREIGN KEY  (FORMIROV_ID)
               REFERENCES FORMIROV ) ;


ALTER TABLE MATERIALOB
ADD  (  FOREIGN KEY  (MATERIAL_ID)
               REFERENCES MATERIAL ) ;


ALTER TABLE MATERIALOB
ADD  (  FOREIGN KEY  (OBJECT_ID)
               REFERENCES OBECONOM ) ;


ALTER TABLE MATTEH
ADD  (  FOREIGN KEY  (SERVIS_ID)
               REFERENCES SERVIS ) ;


ALTER TABLE MATTEHOB
ADD  (  FOREIGN KEY  (MATTEH_ID)
               REFERENCES MATTEH ) ;


ALTER TABLE MATTEHOB
ADD  (  FOREIGN KEY  (OBJECT_ID)
               REFERENCES OBECONOM ) ;


ALTER TABLE OBECONOM
ADD  (  FOREIGN KEY  (POSTGO_ID)
               REFERENCES POSTGO ) ;


ALTER TABLE OBECONOM
ADD  (  FOREIGN KEY  (POST_ID)
               REFERENCES POST ) ;


ALTER TABLE OBECONOM
ADD  (  FOREIGN KEY  (DEPARTAMENT_ID)
               REFERENCES DEPARTAMENT ) ;


ALTER TABLE OBECONOM
ADD  (  FOREIGN KEY  (REGION_ID)
               REFERENCES REGION ) ;


ALTER TABLE OBECONOM
ADD  (  FOREIGN KEY  (ACTIVITY_ID)
               REFERENCES ACTIVITY ) ;


ALTER TABLE OBECONOM
ADD  (  FOREIGN KEY  (PROPERTY_ID)
               REFERENCES PROPERTY ) ;


ALTER TABLE OBECONOM
ADD  (  FOREIGN KEY  (RISK_ID)
               REFERENCES RISK ) ;


ALTER TABLE OBECONOM
ADD  (  FOREIGN KEY  (PECULIAR_ID)
               REFERENCES PECULIAR ) ;


ALTER TABLE ORAUSER
ADD  (  FOREIGN KEY  (GOBASEUSER_ID)
               REFERENCES GOBASEUSER ) ;


ALTER TABLE STUDY
ADD  (  FOREIGN KEY  (SPOST_ID)
               REFERENCES SPOST ) ;


ALTER TABLE STUDY
ADD  (  FOREIGN KEY  (OBJECT_ID)
               REFERENCES OBECONOM ) ;


ALTER TABLE STUDY
ADD  (  FOREIGN KEY  (CATEGORY_ID)
               REFERENCES CATEGORY ) ;


ALTER TABLE TEHNICAOB
ADD  (  FOREIGN KEY  (OBJECT_ID)
               REFERENCES OBECONOM ) ;


ALTER TABLE TEHNICAOB
ADD  (  FOREIGN KEY  (TEHNICA_ID)
               REFERENCES TEHNICA ) ;
/
DROP INDEX IFKGORAUSER;

CREATE UNIQUE INDEX IFKGORAUSER
ON ORAUSER
(
GOBASEUSER_ID ASC
);

DROP INDEX IFKNOOBECONOM;
CREATE UNIQUE INDEX IFKNOOBECONOM
ON OBECONOM
(
OBJECTNO ASC
);
/

ALTER TABLE GO.OBECONOM ADD
(
 FOREIGN KEY ( GLAVOBJECT_ID )
 REFERENCES
 GO.OBECONOM(OBJECT_ID)
);

ALTER TABLE GO.STUDY ADD
(
 FOREIGN KEY ( NAMEADD_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.STUDY ADD
(
 FOREIGN KEY ( NAMEINS_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);


ALTER TABLE GO.OBECONOM ADD
(
 FOREIGN KEY ( NAMEADD_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.OBECONOM ADD
(
 FOREIGN KEY ( NAMEINS_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);


ALTER TABLE GO.MATERIALOB ADD
(
 FOREIGN KEY ( NAMEADD_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.MATERIALOB ADD
(
 FOREIGN KEY ( NAMEINS_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.BUILDINGOB ADD
(
 FOREIGN KEY ( NAMEADD_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.BUILDINGOB ADD
(
 FOREIGN KEY ( NAMEINS_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);


ALTER TABLE GO.TEHNICAOB ADD
(
 FOREIGN KEY ( NAMEADD_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.TEHNICAOB ADD
(
 FOREIGN KEY ( NAMEINS_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.FORMIROVOB ADD
(
 FOREIGN KEY ( NAMEADD_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.FORMIROVOB ADD
(
 FOREIGN KEY ( NAMEINS_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);


ALTER TABLE GO.MATTEHOB ADD
(
 FOREIGN KEY ( NAMEADD_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.MATTEHOB ADD
(
 FOREIGN KEY ( NAMEINS_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.CATTEMA  ADD
(
 FOREIGN KEY ( NAMEADD_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);

ALTER TABLE GO.CATTEMA  ADD
(
 FOREIGN KEY ( NAMEINS_ID )
 REFERENCES
 GO.GOBASEUSER(GOBASEUSER_ID)
);
/

CREATE TRIGGER IU_STUDY BEFORE INSERT OR UPDATE ON GO.STUDY
FOR EACH ROW
BEGIN

IF INSERTING THEN

 SELECT GOBASEUSER_ID INTO :NEW.NAMEADD_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEADD := SYSDATE;

END IF;

 SELECT GOBASEUSER_ID INTO :NEW.NAMEINS_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEINS := SYSDATE;

END;
/

CREATE TRIGGER IU_OBECONOM BEFORE INSERT OR UPDATE ON GO.OBECONOM
FOR EACH ROW
BEGIN

IF INSERTING THEN

 SELECT GOBASEUSER_ID INTO :NEW.NAMEADD_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEADD := SYSDATE;

END IF;

 SELECT GOBASEUSER_ID INTO :NEW.NAMEINS_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEINS := SYSDATE;

END;
/

CREATE TRIGGER IU_MATERIALOB BEFORE INSERT OR UPDATE ON GO.MATERIALOB
FOR EACH ROW
BEGIN

IF INSERTING THEN

 SELECT GOBASEUSER_ID INTO :NEW.NAMEADD_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEADD := SYSDATE;

END IF;

 SELECT GOBASEUSER_ID INTO :NEW.NAMEINS_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEINS := SYSDATE;

END;
/

CREATE TRIGGER IU_BUILDINGOB BEFORE INSERT OR UPDATE ON GO.BUILDINGOB
FOR EACH ROW
BEGIN

IF INSERTING THEN

 SELECT GOBASEUSER_ID INTO :NEW.NAMEADD_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEADD := SYSDATE;

END IF;

 SELECT GOBASEUSER_ID INTO :NEW.NAMEINS_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEINS := SYSDATE;

END;
/

CREATE TRIGGER IU_FORMIROVOB BEFORE INSERT OR UPDATE ON GO.FORMIROVOB
FOR EACH ROW
BEGIN

IF INSERTING THEN

 SELECT GOBASEUSER_ID INTO :NEW.NAMEADD_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEADD := SYSDATE;

END IF;

 SELECT GOBASEUSER_ID INTO :NEW.NAMEINS_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEINS := SYSDATE;

END;
/

CREATE TRIGGER IU_TEHNICAOB BEFORE INSERT OR UPDATE ON GO.TEHNICAOB
FOR EACH ROW
BEGIN

IF INSERTING THEN

 SELECT GOBASEUSER_ID INTO :NEW.NAMEADD_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEADD := SYSDATE;

END IF;

 SELECT GOBASEUSER_ID INTO :NEW.NAMEINS_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEINS := SYSDATE;

END;
/

CREATE TRIGGER IU_MATTEHOB BEFORE INSERT OR UPDATE ON GO.MATTEHOB
FOR EACH ROW
BEGIN

IF INSERTING THEN

 SELECT GOBASEUSER_ID INTO :NEW.NAMEADD_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEADD := SYSDATE;

END IF;

 SELECT GOBASEUSER_ID INTO :NEW.NAMEINS_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEINS := SYSDATE;

END;
/


CREATE TRIGGER IU_CATTEMA BEFORE INSERT OR UPDATE ON GO.CATTEMA
FOR EACH ROW
BEGIN

IF INSERTING THEN

 SELECT GOBASEUSER_ID INTO :NEW.NAMEADD_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEADD := SYSDATE;

END IF;

 SELECT GOBASEUSER_ID INTO :NEW.NAMEINS_ID
  FROM GO.ORAUSER
 WHERE  ORAUSER_ID=UID;
:NEW.DATEINS := SYSDATE;

END;
/

CREATE SEQUENCE S_STUDY;
CREATE SEQUENCE S_CATEGORY;
CREATE SEQUENCE S_TEMA;
CREATE SEQUENCE S_SPOST;
CREATE SEQUENCE S_OBECONOM;
CREATE SEQUENCE S_PECULIAR;
CREATE SEQUENCE S_REGION;
CREATE SEQUENCE S_RISK;
CREATE SEQUENCE S_DEPARTAMENT;
CREATE SEQUENCE S_PROPERTY;
CREATE SEQUENCE S_ACTIVITY;
CREATE SEQUENCE S_POST;
CREATE SEQUENCE S_POSTGO;
CREATE SEQUENCE S_MATERIAL;
CREATE SEQUENCE S_BUILDING;
CREATE SEQUENCE S_TEHNICA;
CREATE SEQUENCE S_MATTEH;
CREATE SEQUENCE S_SERVIS;
CREATE SEQUENCE S_FORMIROV;
CREATE SEQUENCE S_READY;
/