#ifndef __NETBIOS_H
# define __NETBIOS_H

typedef unsigned char byte;
typedef unsigned int  word;

/* Network Control Block (NCB)  */

typedef struct
    {
    byte NCB_COMMAND;               /* command id                         */
    byte NCB_RETCODE;               /* immediate return code              */
    byte NCB_LSN;                   /* local session number               */
    byte NCB_NUM;                   /* network name number                */
    void far *NCB_BUFFER_PTR;       /* address of message packet          */
    word NCB_LENGTH;                /* length of message packet           */
    byte NCB_CALLNAME[16];          /* name of the other computer         */
    byte NCB_NAME[16];              /* our network name                   */
    byte NCB_RTO;                   /* receive time-out in 500 ms. incrs. */
    byte NCB_STO;                   /* send time-out - 500 ms. increments */
    void interrupt (*POST_FUNC)(void); /* address of POST routine         */
    byte NCB_LANA_NUM;              /* adapter number (0 or 1)            */
    byte NCB_CMD_CPLT;              /* final return code                  */
    byte NCB_RESERVE[14];           /* Reserved area                      */
    } NCB;


/* NetBIOS error return messages  */

char    *net_error_message[] = {
        "ᯥ譮 襭",          /*  00  */
        "ୠ  ",        /*  01  */
        "  02",                  /*  02  */
        "ୠ ",              /*  03  */
        "  04",                  /*  04  */
        "⠩-",                    /*  05  */
        " ᫨誮 ",             /*  06  */
        "  07",                  /*  07  */
        "  ᥠ",            /*  08  */
        " ᮢ",                     /*  09  */
        "ᥠ ",                     /*  0A  */
        " ࢠ",                 /*  0B  */
        "  0C",                  /*  0C  */
        "㡫஢ 쭮 ",    /*  0D  */
        "९ ⠡ ",        /*  0E  */
        "ᥠ ⨢",                    /*  0F  */
        "  10",                  /*  10  */
        "९ ⠡ ᥠᮢ",     /*  11  */
        " ",                   /*  12  */
        "  ",              /*  13  */
        " ⢥",                       /*  14  */
        " 쭮 ",             /*  15  */
        " 㦥 ᯮ",             /*  16  */
        " 㤠",                      /*  17  */
        "ଠ쭮 襭",          /*  18  */
        "䫨 ",                    /*  19  */
        "  1A",                  /*  1A  */
        "  1B",                  /*  1B  */
        "  1C",                  /*  1C  */
        "  1D",                  /*  1D  */
        "  1E",                  /*  1E  */
        "  1F",                  /*  1F  */
        "  20",                  /*  20  */
        " ",                    /*  21  */
        "᫨誮  ",             /*  22  */
        "  ",          /*  23  */
        "⬥ 믮",                 /*  24  */
        "  25",                  /*  25  */
        "⬥ "                 /*  26  */
        };

/* Symbolic names for NetBIOS commands  */

#define RESET                           0x32
#define CANCEL                          0x35
#define STATUS                          0xb3
#define STATUS_WAIT                     0x33
#define TRACE                           0xf9
#define TRACE_WAIT                      0x79
#define UNLINK                          0x70
#define ADD_NAME                        0xb0
#define ADD_NAME_WAIT                   0x30
#define ADD_GROUP_NAME                  0xb6
#define ADD_GROUP_NAME_WAIT             0x36
#define DELETE_NAME                     0xb1
#define DELETE_NAME_WAIT                0x31
#define CALL                            0x90
#define CALL_WAIT                       0x10
#define LISTEN                          0x91
#define LISTEN_WAIT                     0x11
#define HANG_UP                         0x92
#define HANG_UP_WAIT                    0x12
#define SEND                            0x94
#define SEND_WAIT                       0x14
#define SEND_NO_ACK                     0xf1
#define SEND_NO_ACK_WAIT                0x71
#define CHAIN_SEND                      0x97
#define CHAIN_SEND_WAIT                 0x17
#define CHAIN_SEND_NO_ACK               0xf2
#define CHAIN_SEND_NO_ACK_WAIT          0x72
#define RECEIVE                         0x95
#define RECEIVE_WAIT                    0x15
#define RECEIVE_ANY                     0x96
#define RECEIVE_ANY_WAIT                0x16
#define SESSION_STATUS                  0xb4
#define SESSION_STATUS_WAIT             0x34
#define SEND_DATAGRAM                   0xa0
#define SEND_DATAGRAM_WAIT              0x20
#define SEND_BCST_DATAGRAM              0xa2
#define SEND_BCST_DATAGRAM_WAIT         0x22
#define RECEIVE_DATAGRAM                0xa1
#define RECEIVE_DATAGRAM_WAIT           0x21
#define RECEIVE_BCST_DATAGRAM           0xa3
#define RECEIVE_BCST_DATAGRAM_WAIT      0x23

void string16(char* name);
void netbios(NCB far* ncb);

#endif