#include <dos.h>
#include <stdlib.h>
typedef struct _AUX_MODE_ {
    union {
       struct {
         unsigned char len : 2, //  ᨬ
         stop              : 1, // ᫮ ⮯ ⮢
         parity            : 2, // ஫ ⭮
         stuck_parity      : 1, // 䨪 ⭮
         en_break_ctl      : 1, // ⠭ 뢠
         dlab              : 1; // 㧪 ॣ ⥫
         }ctl_word;
        char ctl;
    }ctl_aux;
    unsigned long baud; //᪮ । 
    }AUX_MODE;

//㭪 । ० ᨭ஭ 
void aux_stat (AUX_MODE *mode, int port) {

    unsigned long b;

    mode->ctl_aux.ctl=(char)inp(0x3fb-0x100*port);
    outp(0x3fb-0x100*port,mode->ctl_aux.ctl|0x80);
    b=inp(0x3f9-0x100*port);
    b=b<<8;
    b+=inp(0x3f8-0x100*port);
    mode->baud=115200/b;
    outp(0x3fb-0x100*port,mode->ctl_aux.ctl & 0x7f);
}
//㭪 樠樨 ᨭ஭ 
void aux_init (AUX_MODE *mode, int port, int imask) {
    unsigned b;
    char ctl;
    b=115200/(mode->baud);

   //뢠 祭 ⥫ 
    ctl=inp(0x3fb-0x100*port);
    outp(0x3fb-0x100*port,ctl|0x80);
    outp(0x3f9-0x100*port,(b>>8) & (0x00ff));
    outp(0x3f8-0x100*port,b & 0x00ff);

    //뢠  ࠢ饥 ᫮
    outp(0x3fb-0x100*port,mode->ctl_aux.ctl & 0x7f);
    outp(0x3f9-0x100*port,imask);
}
//㭪 뢮 ᨬ  ᨭ஭ 
void aux_outp(char chr, int port)
{
  unsigned status_reg, out_reg;
  status_reg=0x3fd-0x100*port;
  out_reg=status_reg-5;
  while((inp(status_reg) & 0x20) == 0);
  outp(out_reg,chr);
}

//㭪  ᨬ  ᨭ஭ 
char aux_inp(int port)
{
  unsigned status_reg, inp_reg, c=0;
  status_reg=0x3fd-0x100*port;
  inp_reg=status_reg-5;
  if ((inp(status_reg) & 1) == 1) { c=inp(inp_reg);}
  return(c);
}
void usage(void)
{
        printf("\n ணࠬ  ⠭ 裡   "
               "\n ࠬ १ ᨭ஭  \n"
               "\n ࠬ  ப (易⥫) "
               "\n  ᪮ ਢ ࠬ  㬮砭 "
               "\n -c  COM- 1,2                           (1)"
               "\n -s ᫮ ⮯ ⮢ 1,2                      (1)"
               "\n -p ஫ ⭮ 0,1,2                       (0)"
               "\n -l  ᨬ   5,6,7,8                 (8)"
               "\n -b ᪮ । 110,150,300,600,1200,2400,4800,9600,"
               "\n                      19200,38400,57600,115200    (115200) \n"
               "\n ਬ:  chat.exe  -c1 -s1 -p0 -l8 -b115200 ");
        exit(0);
}
int port;
void main(int argc,char *argv[])
{
        AUX_MODE amd;
        unsigned char c1,c2;
        unsigned long c;
        int i;
        char *temp;
        amd.ctl_aux.ctl=3;
        amd.baud=115200;
        printf("\n Froloff Roman Chat for UART \n");
        for(i=1;i<argc;i++)
        {
          if ((argv[i][0]=='-') || (argv[i][0]=='/'))
          {
           strcpy(temp,&argv[i][2]);
           c=strtol(temp,0,10);
           switch (argv[i][1])
           {
             case 'c':
                     {if (c==1 || c==2)
                        port=c-1;
                        else usage();} break;
             case 'l':
                     {if (c>4 && c<9)
                     amd.ctl_aux.ctl_word.len=c-5;
                     else usage();}break;
             case 'p':
                     {if (c==0 || c==1 || c==3)
                     amd.ctl_aux.ctl_word.parity=c+(c>>1);
                     else usage();}break;
             case 's':
                     {if (c==1 || c==2)
                        amd.ctl_aux.ctl_word.stop=c-1;
                        else usage();} break;
             case 'b':
                     {switch(c)
                     case 110:amd.baud=c;break;
                     case 150:amd.baud=c;break;
                     case 300:amd.baud=c;break;
                     case 600:amd.baud=c;break;
                     case 1200:amd.baud=c;break;
                     case 2400:amd.baud=c;break;
                     case 4800:amd.baud=c;break;
                     case 9600:amd.baud=c;break;
                     case 19200:amd.baud=c;break;
                     case 38400:amd.baud=c;break;
                     case 57600:amd.baud=c;break;
                     case 115200:amd.baud=c;break;
                     default: usage();break;
                      }
           }
          }
          else usage();
        }

        aux_init(&amd,port,0);
        printf("\n Esc  뢠 ᮥ\n");
        for(;;){
           if (kbhit()) {c1=getch();}
           if (c1!=0)
           {
l1:        aux_outp(c1,0);
           if (c1==13) {
                       c1=10;
                       goto l1;
                      }
           if (c1==27) break;
           c1=0;
           }
           c2=aux_inp(0);
           if (c2==27) {
                       printf("\n 裡");
                       break;
                       }
           if (c2!=0) {putchar(c2);}
           if (c1==27) break;
        }
       aux_stat(&amd,port);
       printf("\nﭨ  COM %d :"
               "\n ᨬ          %d"
               "\n⢮ ⮯ ⮢    %d"
               "\n ।            %lu",
               port+1,
               amd.ctl_aux.ctl_word.len+5,
               amd.ctl_aux.ctl_word.stop+1,
               amd.baud);
       switch(amd.ctl_aux.ctl_word.parity){
       case 1:printf("\nᯮ ஫  ⭮");break;
       case 3:printf("\nᯮ ஫  ⭮");break;
       default:printf("\n஫  ⭮  ᯮ ");break;
       }
       printf("\n\n\a");
}