;File rash.lsp
;(ਫ  祡 ᨨ 몠  ?).
;ন 㭪樨, 騥 ⥪ ? ᯠ.

;㭪 APPEND1 ᮥ  ᯨ᪠  
(defun append1 (l p)
       (if (null l) p	   ;L  -  P (᫮ 砭),
	   (cons (car l)   ; - ᮧ ᯨ᮪,
		 (append1 (cdr l) p)))) ;ᯮ ४.

;EQUAL1 - ᪠ 筮 ꥪ⮢ (ࠫ쭠 ४)
(defun equal1 (u v)
       (cond ((null u) (null v))	   ;頥 T ᫨ U  V 
	     ((numberp u) (if (numberp v) (= u v) ;  ஢ઠ
			      nil))		  ; 筮
	     ((numberp v) nil)			  ;    ᥫ
	     ((atom u) (if (atom v) (eq u v)	  ;ࠢ ⮬
			   nil))
	     ((atom v) nil)
	     (t (and (equal1 (car u) (car v))  ;  筮 ""
		     (equal1 (cdr u) (cdr v)))))) ;筮 "⮢"

;DELETE1 - 㤠  X  ᯨ᪠ L
(defun delete1 (x l)
       (cond ((null l) nil)
	     ((equal1 (car l) x) (delete1 x (cdr l)))
	     (t (cons (car l) (delete1 x (cdr l)))))) ; 믮
		; 砥 믮 ।.

;FULLENGTH1 - ।   ᯨ᪠ L (  ஢)
(defun fullength1 (l)
       (cond ((null l) 0)  ; ⮣ ᯨ᪠ 蠥 0
	     ((atom l) 1)  ;᫨ L  ⮬ - 頥 1
	     (t (+ (fullength1 (car l))     ;  㡨
		   (fullength1 (cdr l)))))) ;  ਭ

;DELETELIST1 - 㤠  , 室騥  ᯨ᮪ U  ᯨ᪠ V
(defun deletelist1 (u v)
       (cond ((null u) v)
	     (t (delete1 (car u)
			(deletelist1 (cdr u) v)))))

;MEMBER1 - ஢ 宦  U  ᯨ᮪ V  孥 ஢
(defun member1 (u v)
       (cond ((null v) nil)
	     ((equal1 u (car v)) v)
	     (t (member1 u (cdr v)))))
; 砥 ⢨ S-ࠦ U  ᯨ᪥ V 頥 ⮪ ᯨ᪠ V,
;稭騩  X,  ⨢ 砥 १⮬ ᫥  NIL.

;INTERSECTION1 -  ᯨ᮪  ⮢  ᯨ᪮
(defun intersection1 (u v)
       (cond ((null u) nil)
	     ((member1 (car u) v);஢ઠ  宦 "" . U  . V
	      (cons (car u) (intersection1 (cdr u) v)));ᮧ ᯨ᪠
	     (t (intersection1 (cdr u) v))));㦭  뢠

;UNION1 - ꥤ  ᯨ᪠,   ⫨稥  APPEND1,
; १騩 ᯨ᮪   騥 
(defun union1 (u v)
       (cond ((null u) v)
	     ((member1 (car u) v) ;ᥨ
	      (union1 (cdr u) v)) ;    㦭 ⮢
	     (t (cons (car u)
		      (union1 (cdr u) v)))))

;COPY-LIST1 -  孨 ஢ ᯨ᪠
(defun copy-list1 (l)
       (cond ((null l) nil)
	     (t (cons (car l)
		      (copy-list1 (cdr l))))))

;COPY_TREE1 -  ᯨ 
(defun copy-tree1 (l)
       (cond ((null l) nil)
	     ((atom l) l)
	     (t (cons (copy-tree1 (car l))
		      (copy-tree1 (cdr l))))))

;ADJOIN1 -    ᯨ
(defun adjoin1 (x l)
       (cond ((null l) nil)
	     ((atom l) (cons x	 ;᫨ L ⮬,   ८ࠧ  ᯨ᮪,
			     (cons l nil))) ; ⥬    X
	     (t (cons x l))))

;SET-DIFFERENCE1 - 室 ࠧ  ᯨ᪮
(defun set-difference1 (w e)
       (cond ((null w) nil)
	     ((member1 (car w) e)  ;뢠 㦭
	      (set-difference1 (cdr w) e))  ;
	     (t (cons (car w)
		      (set-difference1 (cdr w) e)))))

;COMPARE1 - ࠢ  ࠧ殬
(defun compare1  (p d)
       (cond ((and (null p) (null d)) t)  ;௠ ᯨ᪨?
	     ((or (null p) (null d)) nil) ;  ᯨ᪮?
	     ((or (equal1 (car p) '&)	  ;  ࠧ ⮬ &
		  (equal1 (car p) (car d))) ;  ᯨ᪮ ࠢ
	      (compare1 (cdr p) (cdr d)))   ;& ᮯ⠢   ⮬
	     ((equal1 (car p) '*)	    ;  ࠧ ⮬ *
	      (cond ((compare1 (cdr p) d))  ;*   祬  ᮯ⠢
		    ((compare1 (cdr p) (cdr d))) ;* ᮯ⠢   ⮬
		    ((compare1 p (cdr d))))))) ;* ᮯ⠢  ᪮쪨
					       ;⮬

;SUBSTITUTE1 -   ᯨ᪥ L ⮬ S  ⮬ N
(defun substitute1 (n s l)
       (cond ((null l) nil)
	     ((atom (car l))
	      (cond ((equal1 s (car l))
		     (cons n (substitute1 n s (cdr l))))
		    (t (cons (car l) (substitute1 n s (cdr l))))))
	     (t (cons (substitute1 n s (car l))
		     (substitute1 n s (cdr l))))))

;DELETE-DUPLICATES1 - 㤠  ⮢
(defun delete-duplicates1 (l)
	(cond ((null l) nil)
	      ((member1 (car l) (cdr l))
	       (delete-duplicates1 (cdr l)))
	      (t (cons (car l) (delete-duplicates1 (cdr l))))))

;ATOMLIST1 - ஢ઠ  ஢ ᯨ᮪
(defun atomlist1 (l)
       (cond ((null l) t)
	     ((listp (car l)) nil)
	     (t (atomlist1 (cdr l)))))

;revers1 - 頥 孨 ஢ ᯨ᪠
(defun revers1 (l)
       (cond ((null l) nil)
	     (t (append1 (revers1 (cdr l))
			 (cons (car l) nil)))))
