#include <stdio.h>
#include <dos.h>
#include <ctype.h>
#include <string.h>

#define ERROR	  0
#define IDENT	  1
#define KEYWORD   2
#define BRACKETS  3
#define OTHER	  4
#define BEGIN	  '{'
#define END	  '}'
#define COMMA	  ','
#define SEMI	  ';'
#define LB	  '\n'

// Options
int T=0,N=1,F1=45,F2=80,F3=8,S=0,E=0;

char val[100];
char comment[200];

int  pos=0;
int  undo;
int  backspace;

#define N_KW 8
char keywords[N_KW][20]={
   "for",
   "while",
   "do",
   "if",
   "switch",
   "else",
   "case",
   "default"};
// --------------------------------------------------------------------
int format (FILE *f_in,FILE *f_out);
// --------------------------------------------------------------------

main (int argc,char *argv[])
{
   FILE *f_in,*f_out;
   char *s;

   puts ("ଠ⨧ CPP-䠩. ୠ ࠡ 2.");
   puts ("㭮 ..	 -61		       04.04.1996\n");
   if (argc<2)
   {
      puts ("   :");
      puts ("FCPP.COM  <> <CPP-䠩>");
      puts ("<> :");
      puts ("	-n1	     `{` - ᥣ c  ப  㯠");
      puts ("	-n2	     `{` -   ७");
      puts ("	-n3	     `{` - ᥣ c  ப  㯮");
      puts ("	-tx	     0 -   ⠢ ᨬ TAB  㯥");
      puts ("		     1..8  ⠢ x ஡");
      puts ("	-fxx:yy[:z]  ଠ஢ ਨ c xx  yy 樨");
      puts ("	-s	     ᪮쪮    ப");
      puts ("	-e	     `=` 뤥 ஡");


      return 0;
   }
   // scan the keys
   for (int i=1;i<argc && *argv[i]=='-';i++)
   {
      switch (*(argv[i]+1)) {
	 case 'n': {
	    N=*(argv[i]+2)-'0';
	    if (N>3 || N<0) N=1;
	    break;
	 }
	 case 't': {
	    T=*(argv[i]+2)-'0';
	    if (T>8 || T<0) T=0;
	    break;
	 }
	 case 'e': {
	    E=1;
	    break;
	 }
	 case 'f': {
	    char *s=argv[i]+2;
	    int  buf;

	    F1=0;
	    while (*s!=':' && *s)
	    {
	       F1*=10;
	       F1+=(*(s++)-'0');
	    }
	    if (F1<0 || F1>160) F1=45;
	    if (!*s) break;
	    s++;
	    F2=0;
	    while (*s && *s!=':')
	    {
	       F2*=10;
	       F2+=(*(s++)-'0');
	    }
	    if (F1>=F2 || F2>160) F2=80;
	    if (!*s) break;
	    while (*s)
	       F3=(*(s++)-'0');
	    if (F3<1 || F3>8) F3=8;
	    break;
	 }
	 case 's': {
	    S=1;
	    break;
	 }
      }
   }
   if (!(f_in=fopen(argv[i],"r")))
   {
      printf (" %s  뢠 ...",argv[1]);
      return 0;
   }
   s=argv[i];
   while (*(++s)!='.' && *s);
   *(s-1)='~';
   if (!(f_out=fopen(argv[i],"w")))
   {
      printf (" %s  뢠 ...",argv[1]);
      return 0;
   }

   if (format(f_in,f_out))
      puts (" ଠ஢!\n");
   else
      puts ("訡!\n");
   fclose (f_in);
   fclose (f_out);

   return 0;
}

// -----------------------------------------------------------------
void blockQuote (char *(&s),FILE *f)
{
   char c=fgetc(f);

   *(s++)=c, c=0;
   while (c!='\'' && c!='\"') {
      c=*(s++)=fgetc(f);
      if (c=='\\')
	 c=*(s++)=fgetc(f);
   }
}
// -----------------------------------------------------------------
int getNext (FILE *f)
{
   char *s=val,c;
   int	buf=undo;
   static int symbol=0;
   static int startPos=1;

   // UnDo ?
   if (undo) {
      undo=0;
      return buf;
   }

   c=fgetc(f);
   if (isspace(c))
   {
      startPos=0;
      while(isspace(c) && !feof(f) && c!='\n') c=fgetc(f);
      if (c=='\n') {
	 *val=0;
	 startPos=1;
	 return LB;
      }
   }
   if (feof(f)) return EOF;
   // Drop comments
   if (c=='/') {
      char *s3=comment;

      if ((c=fgetc(f))=='/') {
	 if (startPos) *(s3++)=1;	// Format from startPos
	 else *(s3++)=2;		// Have to format it
	 *(s3++)='/';
	 *(s3++)='/';
	 while ((c=fgetc(f))!='\n') *(s3++)=c;
	 *s3=0;
	 return LB;
      }
      else
      if (c=='*') {
	 *(s3++)=3;			// No format
	 *(s3++)='/';
	 *(s3++)='*';
	 while ((c=fgetc(f))!='/' && !feof(f)) {
	    *(s3++)=c;
	    while ((c=fgetc(f))!='*' && !feof(f)) *(s3++)=c;
	 }
	 *(s3++)='*';
	 *(s3++)='/';
	 *s3=0;
	 c=fgetc (f);
      }
      else {
	 ungetc (c,f);
	 c='/';
      }
   }

   startPos=0;
   if (isalnum(c) || c=='_') {
      symbol=0;
      *(s++)=c;
      while ((isalnum(c) || c=='_' || c=='.') && !feof(f) && !isspace(c))
	 c=*(s++)=fgetc(f);
      ungetc (c,f);
      *(--s)=0;
      for (int i=0;i<N_KW && strcmp(keywords[i],val);i++);
      if (i!=N_KW) *(s++)=' ';
      *s=0;
      if (i!=N_KW) return KEYWORD;
      return IDENT;
   }

   if (c=='\'' || c=='\"') {
      symbol=0;
      ungetc(c,f);
      blockQuote (s,f);
      *s=0;
      return IDENT;
   }

   if (c=='(' || c=='[') {
      int b=1;

      symbol=0;
      *(s++)=c;
      while (!feof(f) && b) {
	 c=fgetc(f);
	 if (c=='\'' || c=='\"')
	 {
	    ungetc (c,f);
	    blockQuote (s,f);
	    c=fgetc(f);
	 }
	 if (c=='(' || c=='[') b++;
	 if (c==')' || c==']') b--;
	 if (c=='=' && E && !symbol) {
	    c=fgetc(f);
	    if (c!='=') {
		*(s++)=' ';
		*(s++)='=';
		*(s++)=' ';
	    }
	    else
		*(s++)='=';
	    ungetc (c,f);
	    symbol=1;
	 }
	 else if (isspace(c)) {
	    while (isspace(c=fgetc(f)) && !feof(f));
	    ungetc(c,f);
	    *(s++)=' ';
	    symbol=0;
	 }
	 else {
	    *(s++)=c;
	    if ((c>32 && c<40) || (c>41 && c<48)) symbol=1;
	    else symbol=0;
	 }
      }
      *s=0;
      return BRACKETS;
   }

   if (c==';' || c==':') {
      symbol=0;
      *s=c, *(s+1)=0;
      return SEMI;
   }

   if (c==',' || c=='{' || c=='}') {
      symbol=0;
      *s=c, *(s+1)=0;
      return c;
   }

   if (c=='=' && E && !symbol)
   {
      *(s++)=' ';
      *(s++)=c;
      *(s++)=' ';
      *s=0;
      return OTHER;
   }

   *s=c, *(s+1)=0;
   symbol=1;
   return OTHER;
}
// -----------------------------------------------------------------
void outComment (FILE *f)
{
   char *s=comment;
   char buf[100];
   char *s1=buf,*back;
   int nl=1;

   if (*s==3)
   {
      // Out as is
      while (*(++s))
	 fputc (*s,f);
      *comment=0;
      return;
   }
   if (*s==1)
   {
      // Out from startPos
      if (pos)
      {
	 fputc ('\n',f);
	 pos=0;
      }

      s++; nl=1;
      while (*s) {
	 s1=buf;
	 back=s;
	 while (*s && *s!=' ' && *s!=9) *(s1++)=*(s++); // Get Word
	 *s1=0;
	 if (*s) s++;
	 if (pos+int(s1-buf)<F2 || nl) {   // OK vlezlo
	    s1=buf;
	    while (*s1) {
	      fputc(*(s1++),f);
	      pos++;
	    }
	    // Out WS
	    fputc(' ',f);
	    pos++;
	    nl=0;
	 }
	 else { 	 // Ne vlezlo
	    s=back;
	    fputc ('\n',f);
	    fputc ('/',f);
	    fputc ('/',f);
	    pos=2;
	    nl=1;
	 }
      }

      *comment=0;
      return;
   }
   if (*s==2)
   {
      s++; nl=1;
      // Set to F1 pos
      for (;pos<F1-1;pos++)
	 fputc (' ',f);

      while (*s) {
	 s1=buf;
	 back=s;
	 while (*s && *s!=' ' && *s!=9) *(s1++)=*(s++); // Get Word
	 *s1=0;
	 if (*s) s++;
	 if (pos+int(s1-buf)<F2 || nl) {   // OK vlezlo
	    s1=buf;
	    while (*s1) {
	      fputc(*(s1++),f);
	      pos++;
	    }
	    // Out WS
	    fputc(' ',f);
	    pos++;
	    nl=0;
	 }
	 else { 	 // Ne vlezlo
	    s=back;
	    fputc ('\n',f);
	    // Set to F1 pos
	    for (pos=0;pos<F1-1;pos++)
	       fputc (' ',f);
	    fputc ('/',f);
	    fputc ('/',f);
	    nl=1;
	 }
      }

      *comment=0;
   }
}

void outVal (FILE *f,int back=0)
{
   char *s=val;

   if (backspace && !back)
   if (!T) {
      fputc (9,f);
      pos+=F3;
   }
   else {
      for (int j=0;j<T;j++)
      {
	 fputc (' ',f);
	 pos++;
      }
   }
   backspace=0;
   while (*s) {
      fputc (*(s++),f);
      pos++;
   }
}

void outCR (FILE *f,int tab,int newLine=0)
{
   int limit=tab-1+newLine;

   // Out Comments
   if (*comment)
      outComment (f);
   if (!newLine) {
       fputc ('\n',f);
       pos=0;
   }
   for (int i=0;i<limit;i++)
   {
      if (!T) {
	 fputc (9,f);
	 pos+=F3;
      }
      else {
	 for (int j=0;j<T;j++)	{
	    fputc (' ',f);
	    pos++;
	 }
      }
   }
   if (tab && !newLine)
      backspace=1;
}
// -----------------------------------------------------------------

int format (FILE *f_in,FILE *f_out)
{
   int	tab=0,tab1=0,tab2=0,lb=0;
   int	lex;

   while (!feof(f_in))
   {
      lex=getNext(f_in);

      //printf ("%d	%d     %s\n",*comment,lex,val);
      //delay (100);

      switch (lex) {
	 case KEYWORD: {
	    lb=0;
	    outVal (f_out);
	    lex=getNext(f_in);
	    if (lex==BRACKETS || lex==IDENT) {
	       outVal(f_out);
	       lex=getNext (f_in);
	    }
	    if (lex==LB) lex=getNext(f_in);
	    if (lex==BEGIN)
	       if (tab1) {
		  tab1=0;
		  tab2++;
		  tab++;
		  if (N!=2) {
		     outCR (f_out,tab);
		     lb=1;
		  }
	       }
	       else
	       {
		  if (N!=2) {
		     outCR (f_out,tab);
		     lb=1;
		  }
	       }
	    else if (lex!=SEMI) {
	       tab1++;
	       outCR (f_out,tab+tab1);
	       lb=1;
	    }
	    undo=lex;
	    break;
	 }
	 case BEGIN: {
	    tab1=0;
	    if (!lb && N!=2) outCR (f_out,tab);
	    if (N==3) outCR (f_out,1,1);
	    outVal(f_out);
	    outCR (f_out,++tab);
	    lb=1;
	    lex=getNext(f_in);
	    if (lex==LB) lex=getNext(f_in);
	    undo=lex;
	    break;
	 }
	 case END: {
	    if (!lb) outCR (f_out,tab);
	    lb=1;
	    tab1=0;
	    if (N==3)
	       outVal(f_out);
	    else
	       outVal(f_out,1);
	    lex=getNext (f_in);
	    if (lex==SEMI) {
	       outVal(f_out);
	       lex=getNext (f_in);
	    }
	    if (lex==LB) lex=getNext(f_in);
	    undo=lex;
	    if (tab2) tab-=tab2+1;
	    else
	       tab--;
	    tab2=0;
	    outCR (f_out,tab);
	    lb=1;
	    break;
	 }
	 case SEMI: {
	    lb=0;
	    tab1=0;
	    outVal (f_out);
	    lex=getNext(f_in);
	    if (!S || lex==KEYWORD || lex==END)
	       if (N!=2 || lex!=BEGIN)
	       {
		  outCR (f_out,tab);
		  lb=1;
	       }
	    if (lex==LB && !S) lex=getNext(f_in);
	    undo=lex;
	    break;
	 }
	 case IDENT: {
	    lb=0;
	    outVal (f_out);
	    lex=getNext (f_in);
	    if (lex==IDENT || lex==KEYWORD) {
	       fputc(' ',f_out);
	       pos++;
	    }
	    undo=lex;
	    break;
	 }
	 case LB: {
	    int used;

	    tab1=0;
	    if (*comment) {
	       outCR (f_out,tab);
	       used=1;
	    }
	    lex=getNext (f_in);
	    if (N!=2 || lex!=BEGIN) {
	       if (!used) outCR (f_out,tab);
	       lb=1;
	    }
	    undo=lex;
	    break;
	 }
	 case EOF:
	    return 1;
	 default: {
	    lb=0;
	    outVal(f_out);
	 }
      }
   }

   return 1;
}