#include <dos.h>
#include <process.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "common.hpp"
#include "error.hpp"
#include "disk.hpp"
#include "scaner.hpp"

struct Makros{                         // 
  char *name;                          //  
  char *def;                           // 祭 , .. ⠭
  Makros *next;                        // 뫪  ᫥騩 
}*spisok_makros,*mak,*mak_tmp;

char *path;           //

void init_preproc()
  {
    mak_tmp=new Makros;
    spisok_makros=0;
    path=new char[100];
  }

// 楤  ࠡ  ᠬ

inline void ins_makros()               // ⠢    ᯨ᮪
  {
    mak->next=spisok_makros;
    spisok_makros=mak;
  }

int test_makros()                      // ஢  稥 
  {
    Makros *cur=spisok_makros;
    while(cur)
      if(!strcmp(cur->name,mak->name))
        return 1;
      else
        cur=cur->next;
    return 0;
  }

void delete_makros()                   //    ᯨ᪠
  {
    Makros *cur=spisok_makros,*pred=cur;

    while(cur->next && strcmp(cur->name,mak->name))
      pred=cur, cur=cur->next;

    if(cur==spisok_makros)
      spisok_makros=cur->next;
    else
      pred->next=cur->next;

    delete cur->name;                  // 塞  

    if(cur->def)                       // 塞 ப 饭 (if )
      delete cur->def;

    delete cur;                        // 塞 

  }

void change_makros()                   //    ᯨ᪥
  {
    Makros *cur=spisok_makros;

    while(cur->next && strcmp(cur->name,mak->name))
      cur=cur->next;

    delete cur->name;
    cur->name=new char [strlen(mak->name)];
    strcpy(cur->name,mak->name);

    if(cur->def)
      delete cur->def;
    if(mak->def)
      cur->def=new char [strlen(mak->def)],
      strcpy(cur->def,mak->def);
  }

Makros *find_makros(char *name)
  {
    int flag=0;
    Makros *cur=spisok_makros;

    while(cur && !flag)
      if(!strcmp(cur->name,name))
        flag=1;
      else
        cur=cur->next;

    return cur;
  }

int test_name_makros(char *name)
  {
    int flag=1;
    mak=new Makros;
    mak->name=new char [strlen(name)];
    strcpy(mak->name,name);
    flag=test_makros();
    delete mak->name;
    delete mak;
    return flag;
  }

void del_makros(char *name)
  {
    mak=new Makros;
    mak->name=new char [strlen(name)];
    strcpy(mak->name,name);
    if(test_makros())
      delete_makros();
    else
      show_error(UndefinedSymbol);
    delete mak->name;
    delete mak;
  }

// 楤 ࠡ⪨ define

void form_def_str()                    // ନ஢ ப 饭
  {
    int flag=0;
    char *def=new char[MAXDEFSTR]; strcpy(def,"");
    Makros *cur;
    while(get_token(SPACES)!=EOLN && type_token!=ENDFILE){
      if(type_token==IDENT)
        if((cur=find_makros(token))!=0)
          strcpy(token,cur->def);
      if(!flag && type_token!=SPACE)
        flag=1,
        strcat(def,token);
      else if(flag)
        strcat(def,token);
    }

    mak->def=new char [strlen(def)];
    strcpy(mak->def,def);

    delete def;
  }

void idefine()                         // ࠡ⪠ define
  {
    mak=new Makros;

    if(get_token(NOSPACES)==IDENT)
      {
        mak->name=new char[strlen(token)];
        strcpy(mak->name,token);
        mak->def=0;
      }
    else
      show_error(DontIDENT);

    form_def_str();                    // ନ㥬 ப 饭

    if(test_makros())                  // ஢ઠ  ⢮ 
      show_warning(MakrosNotIdent),
      change_makros();                 // 塞 騩 
    else
      ins_makros();                    // ⠢塞    ᯨ᮪
  }

void iundef()                          // ࠡ⪠ #undef
  {
    if(get_token(NOSPACES)==IDENT)
      del_makros(token);
    else
      show_error(DontIDENT);
    if(get_token(NOSPACES)!=EOLN && type_token!=ENDFILE)
      show_error(ExpressionSyntax);
    if(type_token==ENDFILE)
      put_token();
  }

// 楤  ࠡ  if,ifdef, ...

void lex();

void search(int flag)
  {
    int a;
    a=stand_makr.sumif-1;
    do
      {
        for(get_token(NOSPACES);strcmp(token,"if") && strcmp(token,"endif") &&
                                strcmp(token,"elif") && strcmp(token,"else") &&
                                strcmp(token,"ifdef") && strcmp(token,"ifndef")
                                ;)
          get_token(NOSPACES);

        if(!strcmp(token,"else") && !flag)
          lex();
        if(!strcmp(token,"if") || !strcmp(token,"ifdef") || !strcmp(token,"ifndef"))
          stand_makr.sumif++;
        if(!strcmp(token,"endif"))
          stand_makr.sumif--;
      }
    while(stand_makr.sumif!=a);
  }

void iif()
 {
  int flag=0;
  get_token(NOSPACES);
  if(!strcmp(token,"defined"))
    {
      if(get_token(NOSPACES)!=LBRACKET)
        show_error(ExpressionSyntax);
      if(get_token(NOSPACES)!=IDENT)
        show_error(DontIDENT);
      flag=test_name_makros(token);
      if(get_token(NOSPACES)!=RBRACKET)
        show_error(ExpressionSyntax);
    }
  else if(type_token==IDENT)
    flag=test_name_makros(token);
  else
    show_error(DontIDENT);

  if(get_token(NOSPACES)!=EOLN && type_token!=ENDFILE)
    show_error(ExpressionSyntax);
  if(type_token==ENDFILE)
    put_token();

  if(flag==1)
    {
      stand_makr.sum_true++;
      lex();
      search(1);
    }
  else
    search(0);
 }

void iifdef(int fl)
  {
    int flag;
    if(get_token(NOSPACES)==IDENT)
      flag=test_name_makros(token);
    else
      show_error(DontIDENT);

    if(get_token(NOSPACES)!=EOLN && type_token!=ENDFILE)
      show_error(ExpressionSyntax);
    if(type_token==ENDFILE)
      put_token();

    if(flag && fl || !flag && !fl)
      {
        stand_makr.sum_true++;
        lex();
        search(1);
      }
    else
      search(0);
  }

// ᪨ 

void lex()
  {
    int n;
    int i;
    int flag;
    Makros *cur;
    if(get_token(NOSPACES)==POUND)
      {
        switch(get_token(NOSPACES)){
          case IDENT: if(!strcmp(token,"include"))
                        {
                          switch(get_token(NOSPACES)){
                            case JL      : strcpy(path,"");
                                           while(get_token(NOSPACES)==IDENT ||
                                                          type_token==POINT ||
                                                          type_token==SLASH)
                                             strcat(path,token);
                                           if(type_token!=JG)
                                             show_error(ExpressionSyntax);
                                           stand_makr.line++;
                                           open_file(path);
                                           break;
                            case STRCONST: strcpy(path,token+1);
                                           i=0;
                                           while(*(path+i)!='"') i++;
                                           *(path+i)=0;
                                           stand_makr.line++;
                                           open_file(path);
                                           break;
                            default      :
                                           show_error(ExpressionSyntax);
                          }
                        }
                      else if(!strcmp(token,"define"))
                        idefine();
                      else if(!strcmp(token,"if"))
                        iif();
                      else if(!strcmp(token,"else"))
                        return;
                      else if(!strcmp(token,"endif"))
                        return;
                      else if(!strcmp(token,"ifdef"))
                        iifdef(1);
                      else if(!strcmp(token,"ifndef"))
                        iifdef(0);
                      else if(!strcmp(token,"undef"))
                        iundef();
                      else
                        show_error(UnknownPreproc);
                      break;
          case EOLN : break;
          default   : show_error(UnknownPreproc);
        }
        lex();
      }
    else if(type_token==ENDFILE)
      {
        if(!close_file())
          return;
        lex();
      }
    else
      {
        flag=0;
        while(flag!=2)
          {
            switch(type_token){
              case DPOUND : show_error(UnknownPreproc);
              case POUND  : if(flag)
                              show_error(IllegalChar);
                            else
                              flag=2;
                            break;
              case EOLN   : if(flag)
                              flag=0,
                              store_text(Correct);
                            break;
              case ENDFILE: if(flag)
                              store_text(NoCorrect);
                            flag=2;
                            break;
              default     : if(type_token==IDENT)
                              if((cur=find_makros(token))!=0)
                                strcpy(token,cur->def);
                            if(!flag && type_token!=SPACE)
                              flag=1,
                              strcpy(stand_makr.out_text,token);
                            else if(flag)
                              strcat(stand_makr.out_text,token);
            }
            if(flag!=2)
              get_token(SPACES);
          }
        put_token();
        lex();
      }
  }

void show_makr()
  {
    Makros *cur=spisok_makros;
    while(cur)
      printf("=%s, 祭=%s\n",cur->name,cur->def),
      cur=cur->next;
  }

void main()
  {
    char name_file[9],full_name[13];
    FILE *file;
    int i=0;

    if(_argc<3)
      printf("Usage:\n      preproc.exe name_file flag_num\n"), exit(0);

    while(i<8 && _argv[1][i] && _argv[1][i]!='.')
      name_file[i]=_argv[1][i],        // 뤥塞  䠩
      i++;
    name_file[i]=0;

    strcpy(full_name,name_file); strcat(full_name,".i");
    if(!(file=fopen(full_name,"wt")))
      printf("Unable open file: %s\n",full_name), getch(), exit(0);
    stand_makr.out_file=file;

    strcpy(full_name,name_file); strcat(full_name,".err");
    if(!(file=fopen(full_name,"wt")))
      printf("Unable open file: %s\n",full_name), getch(), exit(0);
    stand_makr.error_file=file;

    init_common();
    init_disk();
    init_scaner();
    init_preproc();

    stand_makr.flag_num=0;
    if(!strcmp(_argv[2],"1"))
      stand_makr.flag_num=1;

    open_file(_argv[1]);

    lex();

    show_makr();

    getch();

    fclose(stand_makr.out_file);
    fclose(stand_makr.error_file);
  }
