#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <string.h>
#include "common.hpp"
#include "error.hpp"

void show_error(int error)
  {
    char *s=new char[50];

    printf("訡 !!! : %s, ப: %d\n",stand_makr.path,stand_makr.line);
    if(stand_makr.error_file)
      fprintf(stand_makr.error_file,"訡 !!! : %s, ப: %d\n",stand_makr.path,stand_makr.line);

    switch(error){
      case InvalidNumFormat : strcpy(s," ଠ  ᥫ"); break;
      case TooManyDecPoint  : strcpy(s,"誮   祪"); break;
      case IllegalChar      : strcpy(s,"⨬ ᨬ"); break;
      case UnexpectedEOF    : strcpy(s," 䠩  "); break;
      case TokenTooLarge    : strcpy(s," ᥬ ॢ蠥 ⨬ (");
                              strcat(s,MAXTOKENS); strcat(s,")");
                              break;
      case UnterminateStr   : strcpy(s,"襭 ப ⠭"); break;
      case ExpressionSyntax : strcpy(s,"訡  ࠦ"); break;
      case UndefinedSymbol  : strcpy(s," ᨬ"); break;
      case UnknownPreproc   : strcpy(s,"⭠ ९ୠ ४⨢"); break;
      case DontIDENT        : strcpy(s," 䨪"); break;
      case DefineTooLarge   : strcpy(s," ப 饭 ॢ蠥 ⨬ (");
                              strcat(s,MAXDEFSTRS); strcat(s,")");
                              break;
      case MisplacedEndif   : strcpy(s,"訡筮 ७ #endif"); break;
    }
    printf("%s !!!\n",s);
    if(stand_makr.error_file)
      fprintf(stand_makr.error_file,"%s !!!\n",s);
    getch();
    delete s;
    exit(0);
  }

void show_warning(int warning)
  {
    char *s=new char[50];

    printf("।० !!! : %s, ப: %d\n",stand_makr.path,stand_makr.line);
    if(stand_makr.error_file)
      fprintf(stand_makr.error_file,"।० !!! : %s, ப: %d\n",stand_makr.path,stand_makr.line);

    switch(warning){
      case MakrosNotIdent   : strcpy(s,"८।   筮 ।");
                              break;
    }
    printf("%s !!!\n",s);
    if(stand_makr.error_file)
      fprintf(stand_makr.error_file,"%s !!!\n",s);
    delete s;
  }

void insuficient_memory()
  {
    printf("Insuficient memory !!!\n");
    getch();
    exit(0);
  }
