#include <stdio.h>
#include <stdlib.h>

unsigned hash_shift(char *s)
{
   unsigned hash = 0;

   while (*s)
      hash = (hash << 1) + *s++;
   return hash;
}

unsigned hash_rotl(char *s)
{
   unsigned hash = 0;

   while (*s)
      hash = _rotl(hash,1) ^ *s++;
   return hash;
}

long hash_pgw(char *s)
{
   char *p;
   unsigned long h = 0, g;

   for(p=s;*p;p++)
   {
      h = (h << 4) +  *p;
      if (g = h & 0xF0000000)
      {
	 h = h^(g >>24);
	 h = h^g;
      }
   }
   return h;
}

unsigned hash_4 (char *s)
{
   unsigned h = 0;
   const D=5;

   while (*s)
      h = D*h + *s++;
   return h;
}

main (int argc,char **argv)
{
   int n=0,total=0;
   int placed1=0,placed2=0,placed3=0,placed4=0;
   int max1=0,max2=0,max3=0,max4=0;
   int *table1,*table2,*table3,*table4;
   FILE *f;
   char buf[100];

   puts ("ୠ ࠡ 3. ᫥ -㭪樨.");
   puts ("㭮 ..			      -61");

   if (argc<3)
   {
      puts ("\n  HASH.COM <n> <file_name>");
      puts ("	   n - ᫮ ⮢  ⠡");
      puts ("	   file_name -  䠩  䨪ࠬ \n");
      return 0;
   }
   n=atoi(argv[1]);
   if (n<10)
   {
      puts ("\n 誮 쪠 ⠡ \n");
      return 0;
   }
   table1=(int*)calloc(n,sizeof(int));
   table2=(int*)calloc(n,sizeof(int));
   table3=(int*)calloc(n,sizeof(int));
   table4=(int*)calloc(n,sizeof(int));
   if (!table1 || !table2 || !table3 || !table4)
   {
      puts ("\n 墠⠥   ⠡\n");
      return 0;
   }
   if ((f=fopen(argv[2],"r"))==NULL)
   {
      puts ("\n   㪠 䠩\n");
      return 0;
   }

   while (!feof(f))
      if (fscanf (f,"%s",buf)==1)
      {
	 table1[hash_shift(buf)%n]++;
	 table2[hash_rotl(buf)%n]++;
	 table3[hash_pgw(buf)%n]++;
	 table4[hash_4(buf)%n]++;
	 puts (buf);
	 total++;
      }
   puts ("⨪ :");
   for (int i=0;i<n;i++)
   {
      if (table1[i]) {
	 if (max1<table1[i]) max1=table1[i];
	 placed1++;
      }
      if (table2[i]) {
	 if (max2<table2[i]) max2=table2[i];
	 placed2++;
      }
      if (table3[i]) {
	 if (max3<table3[i]) max3=table3[i];
	 placed3++;
      }
      if (table4[i]) {
	 if (max4<table4[i]) max4=table4[i];
	 placed4++;
      }
   }
   printf ("	  HASH_SHIFT : %f  max=%d\n",(float)total/placed1,max1);
   printf ("	  HASH_ROTL  : %f  max=%d\n",(float)total/placed2,max2);
   printf ("	  HASH_PGW   : %f  max=%d\n",(float)total/placed3,max3);
   printf ("	  HASH_4     : %f  max=%d\n",(float)total/placed4,max4);
   fclose (f);

   return 0;
}







