/*
    
                                                                       
                   Project:  HTML 3.0 Browser                            
                    Branch:  Parser/NewObjects                           
                      File:  HTM_NEW.CPP                                 
               Description:  Creating objects & syntax tree              
                             generation routine                          
                    Author:  D.Bergelson                                 
                      Date:  19.04.96                                    
                     Ready:  [?]                                         
                                                                       
       */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <alloc.h>

#include "parser\htm_cnst.h"
#include "parser\htm_glob.h"
#include "parser\htm_tokn.h"
#include "parser\htm_err.h"
#include "class\paragraf.h"
#include "class\text.h"
#include "class\hr.h"
#include "class\image.h"
#include "parse.h"
#pragma  hdrstop

//              DIRS 

void  prepare_all(HTMLbase *Dirs)
{

	if (Dirs == NULL) {
		first = NULL;
      if (debug_yacc) fprintf(tracefp, "NEW ( prepare_all ): No dirs! (Dirs == NULL)\n");
      return;
   }

   first = Dirs;
}

HTMLbase  *add_dir(HTMLbase* Dirs, HTMLbase* Dir)
// chain of dirs (if any)              
// new dir 
{
  HTMLbase  *cDir;

  if (Dir == NULL) return Dirs;

  if (Dirs == NULL) {
     if (debug_yacc) fprintf(tracefp, "NEW ( add_dir ): Dirs == NULL => return Dir.\n");
     return Dir;
  }

  cDir = Dirs;
  while (cDir->next != NULL) cDir = cDir -> next;
  cDir -> next = Dir;

  if (debug_yacc) fprintf(tracefp, "NEW ( add_dir ): Dirs != NULL => 諨  楯窥. ᮥ Dir.\n");

  return Dirs;
}


HTMLbase  *new_dir(const int dType, char* keyword, TAttrContainer* attrs, HTMLbase* text, HTMLbase* nDirs)
//  dir's type                                                          
//  keyword                                             
//  container whith attributes                                  
//  pointer to text (if dir is text)               
//  nested dirs (if any) 
{

   HTMLbase *aDir;
   char aval[64];
   TParagraph *aPar;
   TImage *aImage;

   switch (dType) {

      case tText: {
         if (debug_yacc) fprintf(tracefp, "NEW ( new_dir ): dType == tText => return text (%s)\n", text==NULL?"text==NULL":"text!=NULL");
         return text;
			break;
      } // End of case tText

      case tSingle: {
         if (debug_yacc) fprintf(tracefp, "NEW ( new_dir ): dType == tSingle =>...\n");

         if (strcmp(keyword, "AREA")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "BASE")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "BR")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "DD")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "DT")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "EMBED")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "FRAME")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "HR")==0) {
            // NB! Handle attributes!!!
            aDir = new THorizontalRule(NULL,-1);
            return aDir;
         } else
         if (strcmp(keyword, "IMG")==0) {
            if (attrs) {
               if (attrs->IsPresent("SRC")) {
                  int atype;
                  atype = attrs->GetAttr("SRC", aval);
						aImage = new TImage(aval);
					}
            } else {
					aImage = new TImage("");
            }
				return aImage;
         } else
         if (strcmp(keyword, "INPUT")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "ISINDEX")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "LI")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "LINK")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "META")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "NEXTID")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "OPTION")==0) {
            return NULL;
         } else
         if (strcmp(keyword, "WBR")==0) {
            return NULL;
         }

         break;
      } // End of case tSingle

      case tComplex: {
         if (debug_yacc) fprintf(tracefp, "NEW ( new_dir ): dType == tComplex =>...\n");

         if (strcmp(keyword, "A")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "ADDRESS")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "B")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "BASEFONT")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "BIG")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "BLINK")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "BLOCKQUOTE")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "BODY")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "CAPTION")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "CENTER")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "CITE")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "CODE")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "DFN")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "DIR")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "DIV")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "DL")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "EM")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "FONT")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "FORM")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "FRAMESET")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "H1")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "H2")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "H3")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "H4")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "H5")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "H6")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "HEAD")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "HTML")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "I")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "KBD")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "MAP")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "MENU")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "NOBR")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "NOFRAMES")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "OL")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "P")==0) {
            int atype;
            // NB!!!!!!!!! Handle attributes - for all nested dirs except 'P'
            // 1) Handle Align!!!
            if (attrs) {
               if (attrs->IsPresent("ALIGN")) {
                  atype = attrs->GetAttr("ALIGN", aval);
                  if (strcmp(aval, "RIGHT" )==0) {
							aPar = new TParagraph (RIGHT);
						} else
						if (strcmp(aval, "LEFT"  )==0) {
							aPar = new TParagraph (LEFT);
						} else
						if (strcmp(aval, "CENTER")==0) {
							aPar = new TParagraph (CENTER);
                  } else {
                     MessageBox (0,"No appropriate value found!","New!",MB_ICONSTOP|MB_OK);
                  }
               }
            } else {
					aPar = new TParagraph ();
            }
				aPar -> AddChild(nDirs);
            return aPar;
			} else
         if (strcmp(keyword, "PRE")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "S")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "SAMP")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "SELECT")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "SMALL")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "STRONG")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "SUB")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "SUP")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "TABLE")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "TD")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "TEXTAREA")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "TH")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "TITLE")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "TR")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "TT")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "U")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "UL")==0) {
            return nDirs;
         } else
         if (strcmp(keyword, "VAR")==0) {
            return nDirs;
         }

         break;
      } // End of case tComplex
      default: return NULL;

   } // end of switch

}

HTMLbase  *new_text(HTMLbase* text, char* ident)
//  current text (if exist)            
//  new identifier 
{

   TText *tmp;
   int code;

   if (ident[0] == '\&') { // special character

      if (debug_yacc) fprintf(tracefp, "NEW ( new_text ): processing special character: {%s}\n", ident);

      if (ident[1] == '\#') {
         strcpy(ident, ident+2);
         code = atoi(ident);
         ident[0] = code; ident[1] = '\0';
      } else {
         strcpy(ident, ident+1);

//****   Complete list of special characters on
//****   <http://www.uni-passau.de/%7Eramsch/iso8859-1.html>

         if (strcmp(ident, "lt")  ==0){ident[0] = '\<';ident[1] = '\0';}else
         if (strcmp(ident, "gt")  ==0){ident[0] = '\>';ident[1] = '\0';}else
         if (strcmp(ident, "amp") ==0){ident[0] = '\&';ident[1] = '\0';}else
         if (strcmp(ident, "quot")==0){ident[0] = '\"';ident[1] = '\0';}else
         if (strcmp(ident, "reg") ==0){ident[0] = '\';ident[1] = '\0';}else
         if (strcmp(ident, "copy")==0){ident[0] = '\';ident[1] = '\0';}else
                                       ident[0] = '\0';

      }
   }

   if (text) {
      tmp = dynamic_cast<TText*>(text);
      if (debug_yacc) fprintf(tracefp, "NEW ( new_text ): text!=NULL, dynamic_cast: %s\n", tmp == NULL?"failed":"O'K!");
   } else {
		tmp = new TText("",NORMAL,DEFAULT);
		if (debug_yacc) fprintf(tracefp, "NEW ( new_text ): text==NULL, creating new text: %s \n", tmp == NULL?"failed":"O'K!");
	}
	if (!tmp) return NULL;
   tmp -> AddText(" "); tmp -> AddText(ident);
   return tmp;

}

//                 ATTRIBUTES 

TAttrValue *new_attr_value(int atype, char *value)
{
   TAttrValue *avalue;
   avalue = new TAttrValue(atype, value);
   return avalue;
}

TAttrContainer *new_attr(char *AttrKW, TAttrValue *avalue)
{
   char str[64];
   int atype;
   TAttrContainer *a_cont;

   a_cont = new TAttrContainer();
   if(avalue) {
      atype = avalue -> GetAttrType();
              avalue -> GetAttrValue(str);
   } else {
      atype = -1;
      str[0] = '\0';
   }
   a_cont -> AddAttribute(AttrKW, atype, str);
   delete avalue;
   return a_cont;
}

TAttrContainer *add_attr(TAttrContainer *attrs, TAttrContainer *attr)
{
   char strKW[64];
   int atype;
   char strVal[64];

   if (!attrs) return attr;

   atype = attr  -> GetFirstAttr(strKW, strVal);
   attrs -> AddAttribute(strKW,  atype, strVal);
   delete  attr;
   return attrs;
}
