/*
    
                                                                       
                   Project:  HTML 3.0 Browser                            
                    Branch:  Parser                                      
                      File:  HTML_ATTR.H                                 
               Description:  TAttrContainer Methods                      
                    Author:  D.Bergelson                                 
                      Date:  03.05.96                                    
                     Ready:  [?]                                         
                                                                       
       */

#include <string.h>
#include <stdlib.h>
#include "parser\htm_attr.h"
#pragma hrdstop

//             TAttrValue 

TAttrValue::TAttrValue(int _atype, char *_value)
{
   atype = _atype;
   value = _value;
}

TAttrValue::~TAttrValue()
{
   free(value);
}

TAttrValue::GetAttrType()
{
   return atype;
}

TAttrValue::GetAttrValue(char *_value)
{
   strcpy(_value, value);
   return TRUE;
}

//             TAttrContainer 

TAttrContainer::TAttrContainer()
{
   NAttr = 0;
}

TAttrContainer::~TAttrContainer()
{
   for (int i=0; i<NAttr ; i++) {
      free(Attributes[i].AttrKW );
      free(Attributes[i].AttrVal);
   }
}

TAttrContainer::IsPresent(char *AttrKW)
{
   int i;

   if (NAttr == 0) return FALSE;
   for (i=0; i<NAttr; i++){
      if (strcmp(Attributes[i].AttrKW, AttrKW)==0) return TRUE;
   }
   return FALSE;
}

TAttrContainer::GetFirstAttr  (char *AttrKW, char *AttrVal)
{
   int atype;

   if (NAttr>0) {
      strcpy(AttrKW,  Attributes[0].AttrKW);
      strcpy(AttrVal, Attributes[0].AttrVal);
      atype         = Attributes[0].atype;
   } else {
      strcpy(AttrKW,  "");
      strcpy(AttrVal, "");
      atype        = -1;
   }
   return atype;
}

TAttrContainer::GetAttr (char *AttrKW, char *AttrVal)
{
   int i;
   int atype;

   for (i=0; i<NAttr; i++) {
      if (strcmp(Attributes[i].AttrKW, AttrKW)==0) {
         strcpy(AttrKW,  Attributes[i].AttrKW);
         strcpy(AttrVal, Attributes[i].AttrVal);
         atype         = Attributes[i].atype;
         return atype;
      }
   }
   return -1;
}

TAttrContainer::AddAttribute  (char *AttrKW, int atype, char *AttrVal)
{
   if (NAttr < _MaxAttrs) {
      Attributes[NAttr].AttrKW  = (char *)malloc(strlen(AttrKW) +1);
      Attributes[NAttr].AttrVal = (char *)malloc(strlen(AttrVal)+1);
      strcpy(Attributes[NAttr].AttrKW,  AttrKW);
      strcpy(Attributes[NAttr].AttrVal, AttrVal);
             Attributes[NAttr].atype =  atype;
      NAttr++;
      return TRUE;
   }
   return FALSE;
}
