/*
    
                                                                       
                   Project:  HTML 3.0 Browser                            
                    Branch:  Parser                                      
                      File:  HTML3.Y                                     
               Description:  PC YACC - script of HTML v3.0               
                             language's grammar                          
                    Author:  D.Bergelson                                 
                      Date:  06.03.96                                    
                     Ready:  [?]                                         
                                                                       
       */

%{

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <alloc.h>

#include "parser\htm_cnst.h"
#include "parser\htm_glob.h"
#include "parser\htm_tokn.h"
#include "parser\htm_err.h"
#include "parse.h"

/* extern int yylex(); */

%}


%token _OpenTag       /* <  */
%token _CloseTag      /* </ */
%token _EndTag        /* >  */

%token <pchar> _C_KEYWORD     /* Complex dir's keyword          */
%token <pchar> _S_KEYWORD     /* Single  dir's keyword          */
%token <pchar> _A_KEYWORD     /* Attribute's   keyword          */
%token <pchar> _V_KEYWORD     /* AttrValue's   keyword          */
%token <pchar> _NUM           /* a number                       */
%token <pchar> _IDENTIFIER    /* a identifier                   */
%token <pchar> _QUOTED_ATTR   /* a identifier                   */

%type <pdirs> TOP
%type <pdirs> html_doc
%type <patrs> opt_attrs
%type <patrs> attrs
%type <pattr> attr
%type <pdirs> opt_dirs
%type <pdirs> dirs
%type <p_dir> dir
%type <p_dir> unknown_dir
/* %type <p_dir> bad_dir */
%type <ptext> text
%type <paval> attr_value

/************************************************************

IMPORTANT NOTES:
~~~~~~~~~~~~~~~
     1. This browser will not handle prologue string.
     2. All comments (and prologue string), i.e. all text
        between "<!" tag and a corresponding ">" tag will
        be ignored by yylex().
     3. All checking for valid attributes etc should be in rigth
        part of the corresponding production.

************************************************************/

%start TOP

%%

TOP
   : html_doc
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'TOP' parsed.\n");
       prepare_all($1);
     }
   ;

html_doc
   : opt_dirs
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'html_doc' parsed.\n");
       $$ = $1;
     }
   ;

opt_attrs
   : attrs
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'opt_attrs' parsed as 'attrs'.\n");
       $$ = $1;
     }
   |
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'opt_attrs' parsed as NULL.\n");
       $$ = NULL;
     }
   ;

opt_dirs
   : dirs
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'opt_dirs' parsed as 'dirs'.\n");
       $$ = $1;
     }
   |
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'opt_dirs' parsed as NULL.\n");
       $$ = NULL;
     }
   ;

attrs
   : attr
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attrs' parsed as one 'attr'.\n");
       $$ = add_attr(NULL, $1);
     }
   | attrs attr
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attrs' parsed as 'attrs attr'.\n");
       $$ = add_attr($1, $2);
     }
   ;

dirs
   : dir
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'dirs' parsed as one 'dir'.\n");
       $$ = add_dir(NULL, $1);
     }
   | dirs dir
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'dirs' parsed as 'dirs dir'.\n");
       $$ = add_dir($1, $2);
     }
   ;

dir
   : _OpenTag  _C_KEYWORD opt_attrs _EndTag
        opt_dirs
     _CloseTag _C_KEYWORD           _EndTag
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'dir' parsed as full complex dir.\n");
       $$ = new_dir(tComplex, $2,   $3, NULL, $5);
     }
   | _OpenTag  _S_KEYWORD opt_attrs _EndTag
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'dir' parsed as single dir.\n");
       $$ = new_dir(tSingle, $2,   $3, NULL, NULL);
     }
   | text
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'dir' parsed as 'text'.\n");
       $$ = new_dir(tText, NULL, NULL, $1, NULL);
     }
   | unknown_dir
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'dir' parsed as 'unknown_dir'.\n");
       $$ = $1;
     }
   ;

unknown_dir
   : _OpenTag  _IDENTIFIER   _EndTag
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'dir' parsed as unknown open-part.\n");
       $$ = NULL;
     }
   | _OpenTag  unknown_kw   _EndTag
        opt_dirs
     _CloseTag unknown_kw   _EndTag
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'dir' parsed as unknown close-part.\n");
       /* $$ = new_dir(tComplex, NULL, NULL, NULL, $4); */
       $$ = NULL;
     }
   ;

unknown_kw
   : _IDENTIFIER
     {
       if (debug_yacc) fprintf(tracefp, "YYY: 'unknown_kw' parsed.\n");
     }
   ;

text
   : _IDENTIFIER
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'text' parsed as a single _IDENTIFIER.\n");
       $$ = new_text(NULL, $1);
     }
   | text _IDENTIFIER
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'text' parsed as 'text _IDENTIFIER'.\n");
       $$ = new_text($1, $2);
     }
   ;

attr
   : _A_KEYWORD
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attr' parsed as '_A_KEYWORD'.\n");
       $$ = new_attr($1, NULL);
     }
   | _A_KEYWORD '=' attr_value
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attr' parsed as '_A_KEYWORD = attr_value'.\n");
       $$ = new_attr($1, $3);
     }
   | _IDENTIFIER
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attr' parsed as an unknown.\n");
       $$ = NULL; /* Unknown attribute */
     }
   | _IDENTIFIER '=' attr_value
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attr' parsed as an unknown with a value.\n");
       $$ = NULL; /* Unknown attribute */
     }
   ;

attr_value
   : _V_KEYWORD
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attr_value' parsed as '_V_KEYWORD'.\n");
       $$ = new_attr_value(KWA, $1);     /* KeyWord Attribute */
     }
   | _NUM
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attr_value' parsed as '_NUM'.\n");
       $$ = new_attr_value(NUA, $1);     /* NUmber Attribute */
     }
   | '+' _NUM
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attr_value' parsed as '+ _NUM'.\n");
       $$ = new_attr_value(NPA, $2);     /* Number-Plus Attribute */
     }
   | '-' _NUM
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attr_value' parsed as '- _NUM'.\n");
       $$ = new_attr_value(NMA, $2);     /* Number-Minus Attribute */
     }
   | '"' _QUOTED_ATTR '"'
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attr_value' parsed as \"attr_in_quote\".\n");
       $$ = new_attr_value(QTA, $2);     /* QuoTed Attribute */
     }
   | _IDENTIFIER
     {
       if (debug_yacc) fprintf(tracefp, "YYY:::::: 'attr_value' parsed as an unknown.\n");
       $$ = NULL; /* UNKNOWN ATTRIBUTE VALUE */
     }
   ;

           /************** END of HTML3.Y **************/

