// PolyhedronView.cpp : implementation of the CPolyhedronView class
//

#include "stdafx.h"
#include "Polyhedron.h"
#include "PolyhedronView.h" //header file linking
#include "PolyhedronAction.h"

//  OpenGL
#include "gl\gl.h"
#include "gl\glu.h"
#include "gl\glaux.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

unsigned char threeto8[8] = 
{
	0, 0111>>1, 0222>>1, 0333>>1, 0444>>1, 0555>>1, 0666>>1, 0377
};

unsigned char twoto8[4] = 
{
	0, 0x55, 0xaa, 0xff
};

unsigned char oneto8[2] = 
{
	0, 255
};

static int defaultOverride[13] = 
{
	0, 3, 24, 27, 64, 67, 88, 173, 181, 236, 247, 164, 91
};

//
static PALETTEENTRY defaultPalEntry[20] = 
{
	{ 0,   0,   0,    0 },
	{ 0x80,0,   0,    0 },
	{ 0,   0x80,0,    0 },
	{ 0x80,0x80,0,    0 },
	{ 0,   0,   0x80, 0 },
	{ 0x80,0,   0x80, 0 },
	{ 0,   0x80,0x80, 0 },
	{ 0xC0,0xC0,0xC0, 0 },

	{ 192, 220, 192,  0 },
	{ 166, 202, 240,  0 },
	{ 255, 251, 240,  0 },
	{ 160, 160, 164,  0 },

	{ 0x80,0x80,0x80, 0 },
	{ 0xFF,0,   0,    0 },
	{ 0,   0xFF,0,    0 },
	{ 0xFF,0xFF,0,    0 },
	{ 0,   0,   0xFF, 0 },
	{ 0xFF,0,   0xFF, 0 },
	{ 0,   0xFF,0xFF, 0 },
	{ 0xFF,0xFF,0xFF, 0 }
};

/////////////////////////////////////////////////////////////////////////////
// CPolyhedronView

IMPLEMENT_DYNCREATE(CPolyhedronView, CView)

BEGIN_MESSAGE_MAP(CPolyhedronView, CView) //  
	//{{AFX_MSG_MAP(CPolyhedronView)
	ON_COMMAND(ID_FILE_PLAY, OnFilePlay)
	ON_UPDATE_COMMAND_UI(ID_FILE_PLAY, OnUpdateFilePlay)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_TIMER()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_PAUSE, OnPause)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPolyhedronView construction/destruction

CPolyhedronView::CPolyhedronView()
{
	// TODO: add construction code here
	m_pDC = NULL;
	m_pOldPalette = NULL;
	m_play = FALSE; // ,   Play  
	PolyhedronAct.wAngle=2.1f;
	
}

CPolyhedronView::~CPolyhedronView()
{
}


/////////////////////////////////////////////////////////////////////////////
// CPolyhedronView drawing

void CPolyhedronView::OnDraw(CDC* pDC)
{
	CPolyhedronDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
	DrawScene();
}

/////////////////////////////////////////////////////////////////////////////
// CPolyhedronView diagnostics

#ifdef _DEBUG
void CPolyhedronView::AssertValid() const
{
	CView::AssertValid();
}

void CPolyhedronView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CPolyhedronDoc* CPolyhedronView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPolyhedronDoc)));
	return (CPolyhedronDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPolyhedronView message handlers

void CPolyhedronView::OnFilePlay() 
{
	if (!m_play) //  Play  
	{
		SetTimer(1, 15, NULL);
		m_play = TRUE;
	}
//	else
//		KillTimer(1);
}

void CPolyhedronView::OnUpdateFilePlay(CCmdUI* pCmdUI) 
{
//	pCmdUI->SetCheck(m_play);
}

BOOL CPolyhedronView::PreCreateWindow(CREATESTRUCT& cs) 
{
    // An OpenGL window must be created with the following flags and must not
    // include CS_PARENTDC for the class style. Refer to SetPixelFormat
    // documentation in the "Comments" section for further information.
    cs.style |= WS_CLIPSIBLINGS | WS_CLIPCHILDREN;
	
	return CView::PreCreateWindow(cs);
}

//   
int CPolyhedronView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;

	Init();	// initialize OpenGL
	
	return 0;
}

//   
void CPolyhedronView::OnDestroy() 
{
	HGLRC	hrc;

	KillTimer(1);

	hrc = ::wglGetCurrentContext();

    ::wglMakeCurrent(NULL,  NULL);

    if (hrc)
        ::wglDeleteContext(hrc);

    if (m_pOldPalette)
        m_pDC->SelectPalette(m_pOldPalette, FALSE);

    if (m_pDC)
        delete m_pDC;

	CView::OnDestroy();
}

void CPolyhedronView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
    if(cy > 0)
    {    
        glViewport(0, 0, cx, cy);

        if((m_oldRect.right > cx) || (m_oldRect.bottom > cy))
            RedrawWindow();

        m_oldRect.right = cx;
        m_oldRect.bottom = cy;

        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();  //  
        gluPerspective(45.0f, (GLdouble)cx/cy, 3.0f, 7.0f);
        glMatrixMode(GL_MODELVIEW);
    }
}

void CPolyhedronView::OnTimer(UINT nIDEvent) 
{
	DrawScene();
	
	CView::OnTimer(nIDEvent);

	// Eat spurious WM_TIMER messages
	MSG msg;
	while(::PeekMessage(&msg, m_hWnd, WM_TIMER, WM_TIMER, PM_REMOVE));
}

/////////////////////////////////////////////////////////////////////////////
// GL helper functions

void CPolyhedronView::Init()	//
{
    PIXELFORMATDESCRIPTOR pfd;
//The PIXELFORMATDESCRIPTOR structure describes the pixel format
//of a drawing surface. 
    int         n;
	HGLRC		hrc;
	GLfloat		fMaxObjSize, fAspect;
	GLfloat		fNearPlane, fFarPlane;

//      
	GLfloat mat_emitter[] = {0.1f, 0.1f, 0.1f, 0.1f};
    GLfloat mat_specular[] = {0.0001f, 0.0001f, 0.0001f, 0.0001f};
    GLfloat light_position[] = {1.0f, 1.0f, -0.5f, -1.0f};
	GLfloat lm_ambient[] = {0.3f, 1.0f, -1.0f, -1.0f};
	float icosahedron_diffuse[] = {0.2f, 0.2f, 0.0f, 1.0f};


    m_pDC = new CClientDC(this);

    ASSERT(m_pDC != NULL); //, 

    if (!bSetupPixelFormat())
        return;

    n = ::GetPixelFormat(m_pDC->GetSafeHdc());
    ::DescribePixelFormat(m_pDC->GetSafeHdc(), n, sizeof(pfd), &pfd);

    CreateRGBPalette();

    hrc = wglCreateContext(m_pDC->GetSafeHdc());
    wglMakeCurrent(m_pDC->GetSafeHdc(), hrc);

    GetClientRect(&m_oldRect);
    glClearDepth(1.0f);
    glEnable(GL_DEPTH_TEST);

	if (m_oldRect.bottom)
		fAspect = (GLfloat)m_oldRect.right/m_oldRect.bottom;
	else	// don't divide by zero, not that we should ever run into that...
		fAspect = 1.0f;
	fNearPlane = 3.0f;   //near clipping plane
	fFarPlane = 7.0f;    //far clipping plane
	fMaxObjSize = 3.0f;  //miximum object size
	m_fRadius = fNearPlane + fMaxObjSize / 2.0f;

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity(); //  
    gluPerspective(45.0f, fAspect, fNearPlane, fFarPlane);
    glMatrixMode(GL_MODELVIEW);

// Lights and Rendering Setup
	PolyhedronAct.DefineMaterialf(mat_emitter, mat_specular, icosahedron_diffuse, 5.0);
    
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);
    glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lm_ambient);

    glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
    glDepthFunc(GL_LESS);
    glEnable(GL_DEPTH_TEST);
    glShadeModel(GL_SMOOTH);
}

BOOL CPolyhedronView::bSetupPixelFormat()
{
    static PIXELFORMATDESCRIPTOR pfd = 
	{
        sizeof(PIXELFORMATDESCRIPTOR),  // size of this pfd
        1,                              // version number
        PFD_DRAW_TO_WINDOW |            // support window
          PFD_SUPPORT_OPENGL |          // support OpenGL
          PFD_DOUBLEBUFFER,             // double buffered
        PFD_TYPE_RGBA,                  // RGBA type
        24,                             // 24-bit color depth
        0, 0, 0, 0, 0, 0,               // color bits ignored
        0,                              // no alpha buffer
        0,                              // shift bit ignored
        0,                              // no accumulation buffer
        0, 0, 0, 0,                     // accum bits ignored
        32,                             // 32-bit z-buffer
        0,                              // no stencil buffer
        0,                              // no auxiliary buffer
        PFD_MAIN_PLANE,                 // main layer
        0,                              // reserved
        0, 0, 0                         // layer masks ignored
    };
    int pixelformat;

    if ( (pixelformat = ChoosePixelFormat(m_pDC->GetSafeHdc(), &pfd)) == 0 )
    {
        MessageBox("ChoosePixelFormat failed");
        return FALSE;
    }

    if (SetPixelFormat(m_pDC->GetSafeHdc(), pixelformat, &pfd) == FALSE)
    {
        MessageBox("SetPixelFormat failed");
        return FALSE;
    }

    return TRUE;
}

unsigned char CPolyhedronView::ComponentFromIndex(int i, UINT nbits, UINT shift)
{
    unsigned char val;

    val = (unsigned char) (i >> shift);
    switch (nbits) 
	{

    case 1:
        val &= 0x1;
        return oneto8[val];
    case 2:
        val &= 0x3;
        return twoto8[val];
    case 3:
        val &= 0x7;
        return threeto8[val];

    default:
        return 0;
    }
}


// 
void CPolyhedronView::CreateRGBPalette()
{
    PIXELFORMATDESCRIPTOR pfd;
    LOGPALETTE *pPal;
    int n, i;
 
    n = ::GetPixelFormat(m_pDC->GetSafeHdc());
    ::DescribePixelFormat(m_pDC->GetSafeHdc(), n, sizeof(pfd), &pfd);

    if (pfd.dwFlags & PFD_NEED_PALETTE)
    {
        n = 1 << pfd.cColorBits;
        pPal = (PLOGPALETTE) new char[sizeof(LOGPALETTE) + n * sizeof(PALETTEENTRY)];

        ASSERT(pPal != NULL);

        pPal->palVersion = 0x300;
        pPal->palNumEntries = n;
        for (i=0; i<n; i++)
        {
            pPal->palPalEntry[i].peRed =
                    ComponentFromIndex(i, pfd.cRedBits, pfd.cRedShift);
            pPal->palPalEntry[i].peGreen =
                    ComponentFromIndex(i, pfd.cGreenBits, pfd.cGreenShift);
            pPal->palPalEntry[i].peBlue =
                    ComponentFromIndex(i, pfd.cBlueBits, pfd.cBlueShift);
            pPal->palPalEntry[i].peFlags = 0;
        }

        /* fix up the palette to include the default GDI palette */
        if ((pfd.cColorBits == 8)                           &&
            (pfd.cRedBits   == 3) && (pfd.cRedShift   == 0) &&
            (pfd.cGreenBits == 3) && (pfd.cGreenShift == 3) &&
            (pfd.cBlueBits  == 2) && (pfd.cBlueShift  == 6)
           )
        {
			for (i = 1 ; i <= 12 ; i++)
                pPal->palPalEntry[defaultOverride[i]] = defaultPalEntry[i];
        }

        m_cPalette.CreatePalette(pPal);
        delete pPal;

        m_pOldPalette = m_pDC->SelectPalette(&m_cPalette, FALSE);
        m_pDC->RealizePalette();
    }
}

//  -  
void CPolyhedronView::DrawScene(void)
{
    static BOOL     bBusy = FALSE;
//    static GLfloat  wAngle = 2.1f; // 

//	float icosahedron_diffuse[] = {0.2f, 0.2f, 0.0f, 1.0f};

    if(bBusy) 
		return;
    bBusy = TRUE;

    glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glPushMatrix(); //   

	CPolyhedronDoc* pDoc = GetDocument();

		// 
		PolyhedronAct.Movement(pDoc->m_RotLine_Dir, pDoc->m_RotLine_Dispos,
							pDoc->m_CameraDistance, pDoc->m_RotLine_Dist);

//		glMaterialfv(GL_FRONT, GL_DIFFUSE, icosahedron_diffuse);
		
		// *** :    ,   
		PolyhedronAct.Create(pDoc->m_Polyhedron, pDoc->m_Wired);

	glPopMatrix(); //   

    glFinish();
    SwapBuffers(wglGetCurrentDC());

    bBusy = FALSE;
}

BOOL CPolyhedronView::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}

void CPolyhedronView::OnPause() 
{
	// TODO: Add your command handler code here
	if (m_play) //  Play 
	{
		KillTimer(1);
		m_play = FALSE;
	}
}
