// PolyhedronDoc.cpp : implementation of the CPolyhedronDoc class
//

#include "stdafx.h"
#include "Polyhedron.h"
#include "PolyhedronDoc.h" //header file linking
#include "PolySet.h" //"Settings" dialog

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPolyhedronDoc

IMPLEMENT_DYNCREATE(CPolyhedronDoc, CDocument)

BEGIN_MESSAGE_MAP(CPolyhedronDoc, CDocument)
	//{{AFX_MSG_MAP(CPolyhedronDoc)
	ON_COMMAND(ID_POLYHEDRON_DODECAHEDRON, OnPolyhedronDodecahedron)
	ON_UPDATE_COMMAND_UI(ID_POLYHEDRON_DODECAHEDRON, OnUpdatePolyhedronDodecahedron)
	ON_COMMAND(ID_POLYHEDRON_ICOSAHEDRON, OnPolyhedronIcosahedron)
	ON_UPDATE_COMMAND_UI(ID_POLYHEDRON_ICOSAHEDRON, OnUpdatePolyhedronIcosahedron)
	ON_COMMAND(ID_POLYHEDRON_OCTAHEDRON, OnPolyhedronOctahedron)
	ON_UPDATE_COMMAND_UI(ID_POLYHEDRON_OCTAHEDRON, OnUpdatePolyhedronOctahedron)
	ON_COMMAND(ID_OBJECT_SETTINGS, OnPolyhedronSettings)
	ON_COMMAND(ID_POLYHEDRON_TETRAHEDRON, OnPolyhedronTetrahedron)
	ON_UPDATE_COMMAND_UI(ID_POLYHEDRON_TETRAHEDRON, OnUpdatePolyhedronTetrahedron)
	ON_COMMAND(ID_POLYHEDRON_HEXAHEDRON, OnPolyhedronHexahedron)
	ON_UPDATE_COMMAND_UI(ID_POLYHEDRON_HEXAHEDRON, OnUpdatePolyhedronHexahedron)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPolyhedronDoc construction/destruction

CPolyhedronDoc::CPolyhedronDoc()
{
	// TODO: add one-time construction code here
	//  
	m_Polyhedron = 1;	   // 
	m_RotLine_Dir = 0;     // 
	m_RotLine_Dispos = 0;  // 
	m_RotLine_Dist = 10;   //   
	m_PolySetEdge = 10;    // 
	m_CameraDistance = 50; //    
	m_Wired=FALSE;         //  
}

CPolyhedronDoc::~CPolyhedronDoc()
{
}

BOOL CPolyhedronDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CPolyhedronDoc serialization

void CPolyhedronDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CPolyhedronDoc diagnostics

#ifdef _DEBUG
void CPolyhedronDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CPolyhedronDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPolyhedronDoc commands

//***       
// OnUpdate* -    
void CPolyhedronDoc::OnPolyhedronHexahedron() 
{
	// TODO: Add your command handler code here
	m_Polyhedron = 2;
	UpdateAllViews(NULL);
}

void CPolyhedronDoc::OnUpdatePolyhedronHexahedron(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck (m_Polyhedron == 2 ? 1 : 0);
}

void CPolyhedronDoc::OnPolyhedronDodecahedron() 
{
	// TODO: Add your command handler code here
	m_Polyhedron = 4;
	UpdateAllViews(NULL);
}

void CPolyhedronDoc::OnUpdatePolyhedronDodecahedron(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck (m_Polyhedron == 4 ? 1 : 0);
}

void CPolyhedronDoc::OnPolyhedronIcosahedron() 
{
	// TODO: Add your command handler code here
	m_Polyhedron = 5;
	UpdateAllViews(NULL);
}

void CPolyhedronDoc::OnUpdatePolyhedronIcosahedron(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck (m_Polyhedron == 5 ? 1 : 0);
}

void CPolyhedronDoc::OnPolyhedronOctahedron() 
{
	m_Polyhedron = 3;
	UpdateAllViews(NULL);
}

void CPolyhedronDoc::OnUpdatePolyhedronOctahedron(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_Polyhedron == 3 ? 1 : 0);

}

void CPolyhedronDoc::OnPolyhedronTetrahedron() 
{
	m_Polyhedron = 1;
	UpdateAllViews(NULL);
}

void CPolyhedronDoc::OnUpdatePolyhedronTetrahedron(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_Polyhedron == 1 ? 1 : 0);
}

//"Settings" dialog
void CPolyhedronDoc::OnPolyhedronSettings() 
{
	CPolySet PolySetDlg;

	//***   
	PolySetDlg.m_CameraDistance = m_CameraDistance;
	PolySetDlg.m_Wired = m_Wired;
	PolySetDlg.m_RotLine_Dispos = m_RotLine_Dispos;
	PolySetDlg.m_RotLine_Dir = m_RotLine_Dir;
	PolySetDlg.m_RotLine_Dist = m_RotLine_Dist;

	//    
	if (PolySetDlg.DoModal () == IDOK) //,    OK
	{
		m_CameraDistance = PolySetDlg.m_CameraDistance;
		m_Wired = PolySetDlg.m_Wired;
		m_RotLine_Dispos = PolySetDlg.m_RotLine_Dispos;
		m_RotLine_Dir = PolySetDlg.m_RotLine_Dir;
		m_RotLine_Dist = PolySetDlg.m_RotLine_Dist;
		UpdateAllViews (NULL);
	}
}
