// PolyhedronView.h : interface of the CPolyhedronView class
//
/////////////////////////////////////////////////////////////////////////////
#include "PolyhedronDoc.h"
#include "PolyhedronAction.h"

class CPolyhedronView : public CView
{
protected:
	CString m_ClassName;
	CPolyhedronAction PolyhedronAct;

protected: // create from serialization only
	CPolyhedronView();
	DECLARE_DYNCREATE(CPolyhedronView)

// Attributes
public:
	CPolyhedronDoc* GetDocument();

    CPalette    m_cPalette;
    CPalette    *m_pOldPalette;
	CRect		m_oldRect; //
	float		m_fRadius;
	CClientDC	*m_pDC;

// Operations
public:
	void Init();
	void CreateRGBPalette(void);	// 
    BOOL bSetupPixelFormat(void);	//  
    unsigned char ComponentFromIndex(int i, UINT nbits, UINT shift);
    void DrawScene(void);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPolyhedronView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	protected:
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPolyhedronView();
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	BOOL	m_play; //   Play

// Generated message map functions
protected:
	//{{AFX_MSG(CPolyhedronView)
    afx_msg void OnFilePlay();
	afx_msg void OnUpdateFilePlay(CCmdUI* pCmdUI);
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnPause();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in PolyhedronView.cpp
inline CPolyhedronDoc* CPolyhedronView::GetDocument()
   { return (CPolyhedronDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
