// file: compl.h
// header for fasm translator
#ifndef __COMPL_H
#define __COMPL_H
#include "catypes.h"
#include "cdata.h"
#include "bslist.h"
#include "string.h"
#include "tstream.h"
#include "tstring.h"

class	link_code:public link_base
{
 public:
 COMMAND	command;
 link_code(	long		cNString,
		unsigned int	cadrCom,
		short		clenCom,
		short		ccodeLo,short ccodeHi,
		short		cadrArgLo,short cadrArgHi,
		char		*cadrName
	  )
 {
   command.NString=cNString;
   command.adrCom=cadrCom;
   command.lenCom=clenCom;
   command.codeLo=ccodeLo;
   command.codeHi=ccodeHi;
   command.adrArgLo=cadrArgLo;
   command.adrArgHi=cadrArgHi;
   strcpy(command.adrName,cadrName);
 }
 link_code(void){};
};

class	link_data: public link_base
{
 public:
 short data;
 long  NString;
 link_data(short d,long NS) {data=d;NString=NS;}
};

class	link_error: public link_base
{
 public:
 int nerror;
 long NString;
 link_error(long ns,int ne)
 {
  nerror=ne;
  NString=ns;
 }
 link_error(void){};
};

class	link_adr:public link_base
{
 public:
 ADRESS		adress;
 char		fl;
 long		NString;
 link_adr(char	*cadrName,
	  short	cadrArgLo,short cadrArgHi,long Ns,char f=1
	 )
 {
  strcpy(adress.adrName,cadrName);
  adress.adrArgLo=cadrArgLo;
  adress.adrArgHi=cadrArgHi;
  fl=f;
  NString=Ns;
 }
 link_adr(void){};
};

typedef struct uint_hilo
{
 unsigned Lo:8,Hi:8;
};

union touint
{
 unsigned Int;
 uint_hilo struc;
};

class	compl
{
 list_base lCode;
 list_base lAdr;
 list_base lData;
 list_base lErrors;

 iter_base iCode;
 iter_base iAdr;
 iter_base iData;
 iter_base iErrors;
 tstream*  ins;
 touint	   tCodeAdr,tDataAdr;
 tERROR	   errorLevel;
 unsigned int	StackSize;
 unsigned int	CodeSize;
 unsigned int   DataSize;
 void	   delSpace(char*);
 int	isInc(char*,char*,char**);
 int	getAdr(char*,uint_hilo&);
 int	getCode(char*,uint_hilo&,short&);
 int	getCodeM(char*,char*,short&);
 int	StrData(long,link_data**);
 int	StrCode(long,link_code**);
 int	StrError(long,int&);
 void	delList(list_base&);
 unsigned short	Str2s(char*,char&);
 public:
 compl(tstream* t)
 {
  ins=t;
  iCode.init(&lCode);
  iAdr.init(&lAdr);
  iData.init(&lData);
  iErrors.init(&lErrors);
  tCodeAdr.Int=0;
  tDataAdr.Int=0;
  StackSize=128;
 }
 ~compl(void)
 {
  delList(lCode);
  delList(lAdr);
  delList(lData);
  delList(lErrors);
 }
 void	makelist(void);
 void	updatelist(void);
 int	makeobj(const char*);
 int	makelst(const char*);
 int	makerr(const char*);
 int	isError(void);
};

#endif