// file: cdata.cpp
// data file for fasm translator
#include "cdata.h"

CData	cdata[NCD]=
{
{0,"nop",0x00,0},
{0,"ret",0xd9,0},

{1,"mov ax,c1",0x01,0x01},
{1,"mov ax,c2",0x01,0x02},

{0,"mov ah,al",0x03,0},
{0,"mov al,ah",0x04,0},

{0,"mov bh,bl",0x05,0x0},
{0,"mov bl,bh",0x06,0x2},

{0,"mov fh,al",0x07,0x0},
{0,"mov fh,ah",0x10,0x2},

{0,"mov fh,bl",0x11,0x0},
{0,"mov fh,bh",0x12,0x2},

{0,"mov fl,al",0x13,0x0},
{0,"mov fl,ah",0x14,0x2},

{0,"mov fl,bl",0x15,0x0},
{0,"mov fl,bh",0x16,0x2},

{0,"mov al,fl",0x17,0x0},
{0,"mov al,fh",0x20,0x2},

{0,"mov al,bl",0x21,0x0},
{0,"mov al,bh",0x22,0x2},

{0,"mov ah,fl",0x23,0x0},
{0,"mov ah,fh",0x24,0x2},

{0,"mov ah,bl",0x25,0x0},
{0,"mov ah,bh",0x26,0x2},

{0,"mov bl,fl",0x27,0x0},
{0,"mov bl,fh",0x30,0x2},

{0,"mov bl,al",0x31,0x0},
{0,"mov bl,ah",0x32,0x2},

{0,"mov bh,al",0x33,0x0},
{0,"mov bh,ah",0x34,0x2},

{0,"mov bh,fl",0x35,0x0},
{0,"mov bh,fh",0x36,0x2},

{0,"mov fx,ax",0x37,0x0},
{0,"mov ax,fx",0x40,0x2},
{0,"mov fx,bx",0x41,0x0},
{0,"mov bx,fx",0x42,0x2},
{0,"mov ax,bx",0x43,0x0},
{0,"mov bx,ax",0x44,0x2},

{1,"mov ax,ia",0x45,0x03},
{1,"mov ax,ib",0x45,0x04},
{1,"mov ax,ic",0x45,0x05},
{1,"mov ax,id",0x45,0x06},
{1,"mov ax,ie",0x45,0x07},
{1,"mov ax,if",0x45,0x08},
{1,"mov ax,ih",0x45,0x09},
{1,"mov ax,ik",0x45,0x0a},

{1,"mov bx,ia",0x46,0x03},
{1,"mov bx,ib",0x46,0x04},
{1,"mov bx,ic",0x46,0x05},
{1,"mov bx,id",0x46,0x06},
{1,"mov bx,ie",0x46,0x07},
{1,"mov bx,if",0x46,0x08},
{1,"mov bx,ih",0x46,0x09},
{1,"mov bx,ik",0x46,0x0a},

{0,"mov ia,ax",0x65,0x0},
{0,"mov ia,bx",0x66,0x0},
{0,"mov ib,ax",0x67,0x0},
{0,"mov ib,bx",0x70,0x0},
{0,"mov ic,ax",0x71,0x0},
{0,"mov ic,bx",0x72,0x0},
{0,"mov id,ax",0x73,0x0},
{0,"mov id,bx",0x74,0x0},
{0,"mov ie,ax",0x75,0x0},
{0,"mov ie,bx",0x76,0x0},
{0,"mov if,ax",0x77,0x0},
{0,"mov if,bx",0x80,0x0},
{0,"mov ih,ax",0x81,0x0},
{0,"mov ih,bx",0x82,0x0},
{0,"mov ik,ax",0x83,0x0},
{0,"mov ik,bx",0x84,0x0},

{1,"mov fx,[bx]",0xa2,0x02},
{1,"mov fx,[ax]",0xa2,0x01},
{1,"mov [bx],fx",0xa4,0x02},
{1,"mov [ax],fx",0xa4,0x01},
{1,"mov [bx],ax",0xa6,0x02},
{1,"mov [ax],bx",0xa6,0x01},
{1,"mov ax,[bx]",0xb7,0x02},
{1,"mov bx,[ax]",0xb7,0x01},


{0,"or fx,ax",0xd1,0x0},
{0,"or ax,fx",0xd2,0x2},
{0,"or fx,bx",0xd3,0x0},
{0,"or bx,fx",0xd4,0x2},
{0,"or ax,bx",0xd5,0x0},
{0,"or bx,ax",0xd6,0x2},

{0,"or al,bl",0xe7,0x3},
{0,"or bl,al",0xf0,0x3},
{0,"or ah,al",0xf1,0x3},
{0,"or bh,bl",0xf2,0x3},
{0,"or al,ah",0xf3,0x3},
{0,"or bl,bh",0xf4,0x3},
{0,"or bh,al",0xf5,0x3},
{0,"or bh,ah",0xf6,0x3},
{0,"or ah,bl",0xf7,0x3},
{0,"or ah,bh",0x08,0x3},
{0,"or fl,al",0x09,0x3},
{0,"or fh,ah",0x0a,0x3},
{0,"or fl,bl",0x0b,0x3},
{0,"or fl,bh",0x0c,0x3},

{0,"xor ax,bx",0xb5,0},
{0,"xor bx,ax",0xb6,0},
{0,"xor fx,ax",0xb7,0},
{0,"xor ax,fx",0xd0,0},
{0,"xor al,bl",0xd7,0},
{0,"xor bl,al",0xe0,0},

{0,"shl ax",0x0b,0},
{0,"shl bx",0x0c,0},
{0,"shl fx",0x0d,0},
{0,"shr ax",0x0f,0},
{0,"shr bx",0x10,0},
{0,"shr fx",0x11,0},

{0,"not al",0x0d,0},
{0,"not ah",0x0e,0},
{0,"not bl",0x0f,0},
{0,"not bh",0x18,0},
{0,"not fl",0x19,0},
{0,"not fh",0x1a,0},
{0,"not ax",0x1b,0},
{0,"not bx",0x1c,0},
{0,"not fx",0x1d,0},

{0,"neg al",0x1e,0},
{0,"neg ah",0x1f,0},
{0,"neg bl",0x28,0},
{0,"neg bh",0x29,0},
{0,"neg fl",0x2a,0},
{0,"neg fh",0x2b,0},
{0,"neg ax",0x2c,0},
{0,"neg bx",0x2d,0},
{0,"neg fx",0x2e,0},

{0,"inc ia",0x2f,0},
{0,"dec ia",0x38,0},
{0,"inc ib",0x39,0},
{0,"dec ib",0x3a,0},
{0,"inc ic",0x3b,0},
{0,"dec ic",0x3c,0},
{0,"inc id",0x3d,0},
{0,"dec id",0x3e,0},
{0,"inc ie",0x3f,0},
{0,"dec ie",0x48,0},
{0,"inc if",0x49,0},
{0,"dec if",0x4a,0},
{0,"inc ih",0x4b,0},
{0,"dec ih",0x4c,0},
{0,"inc ik",0x4d,0},
{0,"dec ik",0x4e,0},

{0,"add fx,ax",0x4f,0},
{0,"add fh,fl",0x58,0},
{0,"add fl,al",0x59,0},
{0,"add fl,bl",0x5a,0},
{0,"add fx,bx",0x5b,0},
{0,"add fl,ah",0x5c,0},
{0,"add fl,bh",0x5d,0},

{0,"adc fx,ax",0x5e,0},
{0,"adc fh,fl",0x5f,0},
{0,"adc fl,al",0x68,0},
{0,"adc fl,bl",0x69,0},
{0,"adc fx,bx",0x6a,0},
{0,"adc fl,ah",0x6b,0},
{0,"adc fl,bh",0x6c,0},

{0,"sub fx,ax",0x6d,0},
{0,"sub fh,fl",0x6e,0},
{0,"sub fl,al",0x6f,0},
{0,"sub fl,bl",0x78,0},
{0,"sub fx,bx",0x79,0},
{0,"sub fl,ah",0x7a,0},
{0,"sub fl,bh",0x7b,0},
{0,"sub ax,fx",0x7c,0},
{0,"sub fl,fh",0x7d,0},
{0,"sub al,fl",0x7e,0},
{0,"sub bl,fl",0x7f,0},
{0,"sub bx,fx",0x88,0},
{0,"sub ah,al",0x89,0},
{0,"sub bh,al",0x8a,0},

{0,"mul fx,ax",0x8b,0},
{0,"mul fh,fl",0x8c,0},
{0,"mul fl,al",0x8d,0},
{0,"mul fl,bl",0x8e,0},
{0,"mul fx,bx",0x8f,0},
{0,"mul fl,ah",0x98,0},
{0,"mul fl,bh",0x99,0},
{0,"mul ax,fx",0x9a,0},
{0,"mul fl,fh",0x9b,0},
{0,"mul al,fl",0x9c,0},
{0,"mul bl,fl",0x9d,0},
{0,"mul bx,fx",0x9e,0},
{0,"mul ah,al",0x9f,0},
{0,"mul bh,al",0xa8,0},

{0,"div fx,ax",0xa9,0},
{0,"div fh,fl",0xaa,0},
{0,"div fl,al",0xab,0},
{0,"div fl,bl",0xac,0},
{0,"div fx,bx",0xad,0},
{0,"div fl,ah",0xae,0},
{0,"div fl,bh",0xaf,0},
{0,"div ax,fx",0xb8,0},
{0,"div fl,fh",0xb9,0},
{0,"div al,fl",0xba,0},
{0,"div bl,fl",0xbb,0},
{0,"div bx,fx",0xbc,0},
{0,"div ah,al",0xbd,0},
{0,"div bh,al",0xbe,0},

{0,"cmp fl,al",0xbf,0x1},
{0,"cmp fh,al",0xc8,0x2},
{0,"cmp al,bl",0xc9,0x3},
{0,"cmp ah,bh",0xca,0x3},
{0,"cmp bl,al",0xcb,0x3},
{0,"cmp bh,ah",0xcc,0x3},
{0,"cmp fl,bl",0xcd,0x5},

{0,"ld al",0x85,0x6},
{0,"ld ah",0x86,0x8},
{0,"ld bl",0x87,0x6},
{0,"ld bh",0x90,0x8},
{0,"ld fl",0x91,0x6},
{0,"ld fh",0x92,0x8},

{0,"uld al",0x93,0x6},
{0,"uld ah",0x94,0x8},
{0,"uld bl",0x95,0x6},
{0,"uld bh",0x96,0x8},
{0,"uld fl",0x97,0x6},
{0,"uld fh",0xa0,0x8},

{0,"call ia",0xcf,0x8},

{0,"and ax,bx",0xe8,0},
{0,"and bx,ax",0xe9,0},
{0,"and al,ah",0xea,0},
{0,"and ah,al",0xeb,0},
{0,"and bl,bh",0xec,0},
{0,"and bh,bl",0xed,0},
{0,"and fl,fh",0xee,0},
{0,"and fh,fl",0xef,0},
{0,"and fx,bx",0xf8,0},
{0,"and fx,ax",0xf9,0},
{0,"and ax,fx",0xfa,0},
{0,"and bx,fx",0xfb,0},

{0,"push ax",0xda,0},
{0,"push bx",0xdb,0},
{0,"push fx",0xdc,0},
{0,"pop ax",0xdd,0},
{0,"pop bx",0xde,0},
{0,"pop fx",0xdf,0},
{0,"push ia",0xfc,0},
{0,"push if",0xfd,0},
{0,"pop ia",0xfe,0},
{0,"pop if",0xff,0},
};

CData mcdata[NMCD]=
{
{1,"jmp ",0xc0,0},
{1,"je ",0xc1,0},
{1,"jne ",0xc2,0},
{1,"jc ",0xc3,0},
{1,"jnc ",0xc4,0},
{1,"jmpa ",0xc5,0},
{1,"ja ",0xc6,0},
{1,"jb ",0xc7,0}
};
