#ifndef __TSTRING_H
#define __TSTRING_H
#include <string.h>
template<unsigned int N>
class tBufferString
{
 private:
 char	buf[N];
 public:
 operator char*(void) {return buf;}
 char& operator[](unsigned int i) {return buf[i];}
 tBufferString& operator=(tBufferString& s)
  {
   strcpy(buf,(char*)s);
   return *this;
  }
 tBufferString& operator=(char* s)
  {
   strcpy(buf,s);
   return *this;
  }
 int operator==(tBufferString& s) {return strcmp(buf,(char*)s)==0 ? 1 : 0;}
 int operator==(char* s) {return strcmp(buf,s)==0 ? 1 : 0;}
 int operator!=(tBufferString& s) {return strcmp(buf,(char*)s)==0 ? 0 : 1;}
 int operator!=(char* s) {return strcmp(buf,s)==0 ? 0 : 1;}

 char* operator()(char* s) {return strstr(buf,s);}
 char* operator()(tBufferString& s) {return strstr(buf,(char*)s);}
 char* operator()(char s) {return strchr(buf,s);}
 unsigned int operator()(void) {return len();}

 tBufferString& operator+=(tBufferString& s)
  {strcat(buf,(char*)s);return *this;}
 tBufferString& operator+=(char* s)
  {strcat(buf,s);return *this;}

 unsigned int len(void) {return strlen(buf);}

 operator unsigned int (void) {return len();}
};

#endif