// file: compl.cpp
// fasm translator
#include "compl.h"
#include <conio.h>
#include <stdlib.h>
#include "fstream.h"
#include <dos.h>
#include <io.h>
#include <sys\stat.h>
#include <fcntl.h>
#include "error.h"

void	compl::makelist(void)
{
 tBufferString<2049> buf;	// buffer
 tBufferString<25>   tmp;	// temp buffer
 char *p,*t,*d;
 char f=0;       		// temp variables
 short		w;
 unsigned short	num;
 do
 {
  (*ins)>>(char*)buf;
  delSpace((char*)buf);

  if(buf=="#data")     // data arear
  {
   for(;;)
   {
    (*ins)>>(char*)buf;
    delSpace((char*)buf);
    if(buf=="#code" || buf=="#end" || ins->eof()) {ins->escape();break;}
    if(buf.len()==0) continue;
    p=strchr(buf,' ');
    if(p==NULL)
    {
     lErrors.add_at_head(new link_error(ins->GetNString(),4));
     continue;
    }
    *p=0;
    if(p[1]=='?') d=p+1; else
    {
     p++;
     t=strchr(p,' ');
     if(t) {d=t+1;*t=0;} else d=0;
     num=Str2s(p,f);
     if(f)
     {
      lErrors.add_at_head(new link_error(ins->GetNString(),2));
      continue;
     } // error
     lData.add_at_tail(new link_data(num,(int)ins->GetNString()));
     tDataAdr.Int++;
    }
     lAdr.add_at_head(new link_adr((char*)buf,tDataAdr.struc.Lo,tDataAdr.struc.Hi,(int)ins->GetNString()));
    for(;;)
    {
     if(d==0) break;
     p=strchr(d,' ');
     if(p) p[0]=0;
     w=0;
     if(d[0]=='?') {d++;w=1;}
     num=Str2s(d,f);
     if(f && w==1) {num=1;t=p;}
     if(f)
     {
      lErrors.add_at_head(new link_error(ins->GetNString(),2));
      goto DATA_ERR;
     }//error
     unsigned kc=1;
     if(w==1) {kc=num;num=0;}
     for(unsigned ii=0;ii<kc;ii++)
     {
      lData.add_at_tail(new link_data(num,(int)ins->GetNString()));
      tDataAdr.Int++;
     }
     d=p+1;
     if(p==0) d=0;
    }
    tDataAdr.Int++;
    DATA_ERR:
   }
  }

  else if(buf=="#code") // Code arear
  {
   for(;;) 		// Looking for oper.code
   {
    (*ins)>>(char*)buf;
    delSpace((char*)buf);
    if(buf=="#data" || buf=="#end" || ins->eof()) {ins->escape();break;}
    if(buf[0]==0) continue;
    uint_hilo r;
    p=strchr((char*)buf,':');
    if(p!=NULL)
    {
     *p=0;
     p++;
     lAdr.add_at_head(new link_adr(
      (char*)buf,tCodeAdr.struc.Lo,tCodeAdr.struc.Hi,
      (int)ins->GetNString(),0
     ));
    }
    else p=(char*)buf;

    if(!getCode(p,r,w))
    {
     lCode.add_at_tail(new link_code
     (
     (int)ins->GetNString(),		// No String for listing
     tCodeAdr.Int,			// Command offset
     w,					// Command len
     r.Lo,				// Command code lo
     r.Hi,				// Command code hi
     0,0,				// Adress part unused
     ""					// Pointer string unused
     ));
     tCodeAdr.Int+=w+1;
    }else
    if(!getCodeM(p,tmp,w))
    {
     lCode.add_at_tail(new link_code
     (
     (int)ins->GetNString(),		// No String for listing
     tCodeAdr.Int,			// Command offset
     2,					// Command len
     w,					// Command code lo
     0,					// Command code hi
     0,0,				// Adress part
     tmp				// Pointer string
     ));
     tCodeAdr.Int+=2;
    }else
    if(*p!=0)
    {
     // error !!!
     lErrors.add_at_head(new link_error(ins->GetNString(),0));
    }
   }
  }
  else if(buf("#stack"))    // stack arear
  {
   StackSize=Str2s(((char*)buf)+10,f);
   if(f) lErrors.add_at_head(new link_error(ins->GetNString(),2));
  }
  else if(buf=="#end") break;
  else if(buf!="")    // bad arear
  {
   // error
   lErrors.add_at_head(new link_error(ins->GetNString(),3));
  }

 } while(!ins->eof());
 CodeSize=tCodeAdr.Int;
 DataSize=tDataAdr.Int;
}

void	compl::updatelist(void)
{
 touint r;
 iCode.restart();
 while(!(L_EOL)iCode)
 {
 if(((link_code*)iCode())->command.adrName[0]!=0)
  {
   if(getAdr(((link_code*)iCode())->command.adrName,r.struc))
   {
    lErrors.add_at_head(new link_error(((link_code*)iCode())->command.NString,1)); //error
   }
   ((link_code*)iCode())->command.adrArgLo=r.Int-((link_code*)iCode())->command.adrCom-((link_code*)iCode())->command.lenCom;
  }
  ++iCode;
 }
}

#define DF	((link_code*)iCode())->command

int	compl::makeobj(const char* fn)
{
 int f=open(fn,O_CREAT | O_BINARY | O_TRUNC | O_WRONLY,S_IWRITE);
 if(f==NULL) return 1;
 char b;
 char s='s';
 write(f,&s,1);
 write(f,&StackSize,sizeof(StackSize));
 s='d';
 write(f,&s,1);
 write(f,&DataSize,sizeof(DataSize));

 iData.restart();
 while(!(L_EOL)iData)
 {
  b=((link_data*)iData())->data;
  write(f,&b,1);
  ++iData;
 }

 s='c';
 write(f,&s,1);
 write(f,&CodeSize,sizeof(CodeSize));
 iCode.restart();
 while(!(L_EOL)iCode)
 {
  b=DF.codeLo;
  write(f,&b,1);
  if(DF.lenCom&1)
  {
   b=DF.codeHi;
   write(f,&b,1);
  } else
  if(DF.lenCom&2)
  {
   b=DF.adrArgLo;
   write(f,&b,1);
   b=DF.adrArgHi;
   write(f,&b,1);
  }
  ++iCode;
 }

return 0;
}

#define ST	c->command
int	compl::makelst(const char* Fn)
{
 link_code* c;
 link_data* d;
 char	b[6];
 char*	bb;
 unsigned int count;
 int fl,prn,ne;
 date dat;
 struct time tm;
 tDataAdr.Int=0;
 tBufferString<2049> buf;
 ofstream f(Fn);
 if(f.bad()) return 1;
 getdate(&dat);
 gettime(&tm);
 f<<"-ᥬ  333.666\t\t"<<(int)dat.da_day<<'.'<<(int)dat.da_mon<<'.'<<dat.da_year;
 f<<' '<<(int)tm.ti_hour<<':'<<(int)tm.ti_min<<':'<<(int)tm.ti_sec<<endl<<endl;
 f<<":"<<Fn<<endl<<endl;
 // write here
 f<<"N"<<' '<<""<<"\t"<<""<<"\t\t\t\t室 ⥪\n\n";
 ins->restart();

  do{
  (*ins)>>(char*)buf;
  delSpace((char*)buf);
  iData.restart();
  if(StrError(ins->GetNString(),ne)) // error
  {
   f<<dec;
   f.width(4);
   f<<ins->GetNString()<<' '<<"訡 : "<<Errors[ne]<<(char*)buf<<endl;
  }
  else
  if(StrCode(ins->GetNString(),&c))
  {
   f<<dec;
   f.width(4);
   f<<ins->GetNString()<<' '<<hex;
   f.width(4);
   f<<ST.adrCom<<'\t';
   f.width(2);
   f<<ST.codeLo;
   if(ST.lenCom&1) {f<<' ';f.width(2);f<<ST.codeHi<<'\t';} else
   if(ST.lenCom&2)
   {
    f<<' ';f.width(2);sprintf(b,"%x",ST.adrArgLo);
    bb=b;
    if(strlen(bb)==4) bb+=2;
    f<<bb<<'\t';
   }
   else f<<'\t';
   f<<"\t\t\t"<<(char*)buf<<endl;
  } else

  if(StrData(ins->GetNString(),&d))
  {
    f<<dec;
    f.width(4);
    f<<ins->GetNString()<<' ';
    f.width(4);
    f<<hex<<tDataAdr.Int<<'\t';
    tDataAdr.Int++;
    f.width(2);
    f<<d->data<<' ';
    count=1;
    fl=StrData(ins->GetNString(),&d);
    if(!fl) f<<"\t\t\t\t"<<(char*)buf<<endl;
    prn=1;
    while(fl)
    {
	if(fl)
	{
	 if(count==0) f<<"\t\t";
	 f.width(2);
	 f<<d->data<<' ';
	 tDataAdr.Int++;
	 count++;
	}
	fl=StrData(ins->GetNString(),&d);
	if((prn && count==8) || (prn && !fl))
	{
	 prn=0;if(count!=8)f<<"\t\t\t";else f<<'\t';
	 f<<(char*)buf;
	}
	if(count==8) {count=0;f<<endl;}
	if(!fl) f<<endl;
    }
  }else
  {
   f<<dec;
   f.width(4);
   f<<ins->GetNString()<<"\t\t\t\t\t\t"<<(char*)buf<<endl;
  }

  } while(!ins->eof());
 // write here
 f<<" ᥣ ⥪  : "<<StackSize<<" "<<endl;
 f<<" ᥣ  : "<<DataSize<<" "<<endl;
 f<<" ᥣ    : "<<CodeSize<<" "<<endl<<endl;
  return 0;
}

int	compl::makerr(const char* fn)
{
 if(lErrors.is_empty()) return 0;
 ofstream f(fn);
 if(f.bad()) return 1;
 iErrors.restart();
 while(!(L_EOL)iErrors)
 {
  f<<"ப "<<((link_error*)iErrors())->NString<<" 訡 : "<<Errors[((link_error*)iErrors())->nerror]<<endl;
  ++iErrors;
 }
 return 0;
}

int compl::isError(void)
{
 return (N_ITEMS)lErrors;
}

int compl::getCode(char* s,uint_hilo& r,short& l)
{
 for(register unsigned i=0;i<NCD;i++)
 if(strcmp(s,cdata[i].mnem)==0)
 {
  r.Hi=cdata[i].hi;
  r.Lo=cdata[i].lo;
  l=cdata[i].len;
  return 0;
 }
 return 1;
}

int compl::getAdr(char* name,uint_hilo& r)
{
 iAdr.restart();
 while(!(L_EOL)iAdr)
 {
 if(strcmp(name,((link_adr*)iAdr())->adress.adrName)==0)
  {
   r.Lo=((link_adr*)iAdr())->adress.adrArgLo;
   r.Hi=((link_adr*)iAdr())->adress.adrArgHi;
  return 0;
  }
  ++iAdr;
 }
 return 1;
}

void	   compl::delSpace(char* s)
 {
  register char* p=s+strlen(s)-1;
  if((*p)==' ') *p=0;
  if((*p)==255) *p=0;
  if(*s==' ') memccpy(s,s+1,0,0xffff);
  p=strchr(s,',');
  for(register char i=0;i<2;i++)
  {
  if(p!=0)
  {
   if((*(p-1))==' ') {memccpy(p-1,p,0,0xffff);p--;}
   if((*(p+1))==' ') memccpy(p+1,p+2,0,0xffff);
  }
   p=strchr(s,':');
  }
 }

int compl::isInc(char* s,char* t,char** end)
{
 *end=s;
 for(register unsigned i=0;i<strlen(t);i++)
 {
  (*end)++;
  if(s[i]==0 || s[i]!=t[i]) return 0;
 }
  return 1;
}

unsigned short	compl::Str2s(char* s,char& f)
{
 char* t;
 int   b=10;
 unsigned short r;
 t=strchr(s,'h'); if(t){*t=0;b=16;}
 t=strchr(s,'o'); if(t){*t=0;b=8;}
 t=strchr(s,'n'); if(t){*t=0;b=2;}
 r=(unsigned)strtoul(s,&t,b);
 if(!(*t)) f=0; else f=1;
 return r;
}

int	compl::StrData(long ns,link_data** c)
{
 while(!(L_EOL)iData)
 {
 if(((link_data*)iData())->NString==ns)
  {
  *c=((link_data*)iData());
  ++iData;
  return 1;
  }
  ++iData;
 }
 return 0;
}
int	compl::StrCode(long ns,link_code** c)
{
 iCode.restart();
 while(!(L_EOL)iCode)
 {
 if(((link_code*)iCode())->command.NString==ns)
  {
  *c=((link_code*)iCode());
  return 1;
  }
  ++iCode;
 }
 return 0;
}

int	compl::StrError(long ns,int& er)
{
 if(lErrors.is_empty()) return 0;
 iErrors.restart();
 while(!(L_EOL)iErrors)
 {
  if(((link_error*)iErrors())->NString==ns)
  {
  er=((link_error*)iErrors())->nerror;
  return 1;
  }
  ++iErrors;
 }
 return 0;
}

int compl::getCodeM(char* s,char* Name,short& lo)
{
 char *p;
 for(register unsigned i=0;i<NMCD;i++)
 if(isInc(s,mcdata[i].mnem,&p))
 {
  lo=mcdata[i].lo;
  strcpy(Name,p);
  return 0;
 }
 return 1;
}

void	compl::delList(list_base& l)
{
 link_base* lnk;
 while(!l.is_empty())
 {
  lnk=l.detach_from_head();
  delete lnk;
 }
}