//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//      䥪⨢ ᯨ᮪. .
//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#ifndef __BSLIST_H
#define __BSLIST_H

#include "defs.h"

#define IS_EMPTY BOOL
#define L_EOL    BOOL

class   list_base;

class   iter_base;

class   link_base
 {
        friend class list_base;

        friend class iter_base;

        protected:

        link_base*      next;
 };

class   list_base
 {
        friend  class   iter_base;

        public:

        list_base(void) {list=NULL;flag=FALSE;}

	list_base(link_base* l){list=l;flag=FALSE;}

        BOOL            is_empty(void)  const
                                {return (list==NULL) ? TRUE : FALSE;}

        void            add_at_head(link_base* d)
                                {d->next=list;list=d;}

        void            add_at_tail(link_base*);

        link_base*      detach_from_head(void)
                                {
                                 link_base* buf=list;
                                 if(list!=NULL)
                                  list=list->next;
                                 else flag=TRUE;
                                 return buf;
                                };

        link_base*      detach_from_tail(void);

        operator        N_ITEMS(void)
                                {
                                  N_ITEMS N;
                                  inspect_list(N);
                                  return N;
                                }
        operator        IS_EMPTY(void)
                                {
                                  return is_empty();
                                }
        operator        ERROR(void)
                                {
                                 register ERROR  r=flag;
                                 flag=FALSE;
                                 return r;
                                }
        protected:

        link_base*              inspect_list(N_ITEMS&);

        link_base*      list;

        ERROR           flag;

 };

class iter_base
 {
        public:

	iter_base(list_base* c) {init(c);}

	iter_base(void) {};

	void	init(list_base* c) {cont=c;prev=cur=cont->list;}

        void            restart(void)   {prev=cur=cont->list;}

        link_base*      operator ++ (void);

        link_base*      operator()(void){return cur;}

        void            insert_next(link_base* l);

        void            insert_prev(link_base* l);

        link_base*      detach_next(void);

        link_base*      detach_cur(void);

        operator        L_EOL(void) { return (cur==NULL);}

        protected:

        list_base*      cont;

        link_base*      cur;

        link_base*      prev;

 };
#endif  //      BSLIST_H
