//
//    "OP_WORK.CPP"
//
 #include "op_work.hpp"

 unsigned char request( void )
 {
  unsigned char byR ;
  asm {
   xor ah,ah
   int 16h
   mov byR,al
  }
  return byR ;
 }

 double dEn_stn( int w )
 {
  double dE = dEn + 1.0 ;
  for( int i = 1; i < w; i++ )  dE *= ( dEn + 1.0 ) ;
  return dE ;
 }


 //***********************************************************************
 int ENTRY_DATA::Input( istream& Stream )
 {
  do {
   do {
    clrscr() ;
    cout << "\n\n\r    ᪨ ࠬ஢ \n\n\n\r    ⢮ ࠡ ᬥ  ⪠ [1-3] : " ;
     Stream >> dSmen ;
   } while ( dSmen < 1.0 && dSmen > 3.0 ) ;
   switch ( ( int ) dSmen )
    {
     case 1 : dKrz = 1.0 ; break ;
     case 2 : dKrz = 1.25 ; break ;
     case 3 : dKrz = 1.5 ;
    }

   cout << "\n\r    ꥬ ᪠  N []........" ;
    Stream >> dN ;
   cout << "\r   業   []........................." ;
    Stream >> dCi ;
   cout << "\r   alfa_ [%].................................." ;
    Stream >> dAlfa_t ;
   cout << "\r   alfa_ [1]................................." ;
    Stream >> dAlfa_of ;
   cout << "\r   S [.]...................................." ;
    Stream >> dAveSq ;
   cout << "\r    [.]...................................." ;
    Stream >> dCp ;
   cout << "\r   D []...................................." ;
    Stream >> dDpz ;
   cout << "\r   P []....................................." ;
    Stream >> dPmp ;
   cout << "\r   P []......................................" ;
    Stream >> dPh ;
   cout << "\r   D []...................................." ;
    Stream >> dDgi ;
   cout << "\r   D []...................................." ;
    Stream >> dDop ;
   cout << "\n\r    筮 ? []" ;
  } while ( request() != 0xd ) ;
  return 1 ;
 }

 int ENTRY_DATA::Input( ifstream& Stream )
 {
  char st[15] ;
  Stream.get( st, 15 ) ; Stream.get() ;
  if ( strcmp( st, "Signature" ) )  return 0 ;
  Stream.get( st, 15 ) ; dSmen = atof( st ) ; Stream.get() ;
  switch ( ( int ) dSmen )
   {
    case 1 : dKrz = 1.0 ; break ;
    case 2 : dKrz = 1.25 ; break ;
    case 3 : dKrz = 1.5 ;
   }

  Stream.get( st, 15 ) ; dN = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dCi = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dAlfa_t = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dAlfa_of = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dAveSq = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dCp = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dDpz = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dPmp = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dPh = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dDgi = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dDop = atof( st ) ; Stream.get() ;
  return 1 ;
 }
 //***********************************************************************


 //***********************************************************************
 void TECH_PRO::Reallocate( int iNum )
 {
  iNumber = iNum ;
  if ( ptrData )  delete[] ptrData ;
  ptrData = new DATA_STR[iNum] ;
 }

 void TECH_PRO::Input( istream& Stream )
 {
  clrscr() ;
  do {
   cout << "     । ௫   ᯮ⥫ ࠡ : " ;
   Stream >> dZAR ;
   cout << "     ᫮ ⨢ ࠡ⭨ : " ;
   Stream >> iCH_ad ;
   cout << "     ᫮ ᯮ. ࠡ : " ;
   Stream >> iCH_vs ;

   iCH_a = iCH_ad + iCH_vs ;

   if ( ptrAdm )  delete[] ptrAdm ;
   ptrAdm = new double[iCH_a] ;
   for ( int i = 0; i < iCH_a; i++ )
    {
     cout << "       樥 ⠢ " ;
     if ( i < iCH_ad )  cout << i+1 << "-. ࠡ⭨  : " ;
      else  cout << i+1-iCH_ad << "-. ᯮ⥫쭮 ࠡ⭨ : " ;
     cin >> ptrAdm[i] ;
    }

   cout << endl << "     ।⥫  : " ;
   Stream >> dKpr ;

   do {
    cout << "     ᫮ 権  : " ;
    Stream >> iNumber ;
    if ( iNumber <= 0 )  clrscr() ;
   } while ( iNumber <= 0 ) ;
   Reallocate( iNumber ) ;

   for ( int iCount = 0; iCount < iNumber; iCount++ )
    {
     cout << "n\r   孮᪠  " << iCount+1 << endl ;
     cout << "\r        ଠ 筮 ६ " ;
     Stream >> ptrData[iCount].dTime_Norm ;
     cout << "\r          㤮 " ;
     Stream >> ptrData[iCount].dCost ;
     ptrData[iCount].dTime_Oper =
      ptrData[iCount].dTime_Norm / ( 1 + ( dAlfa + dBetta ) / 100.0 ) ;
    }

    cout << "\n\r    筮 ? []" ;
   } while ( request() != 0xd ) ;
 }

 void TECH_PRO::Input( ifstream& Stream )
 {
  char st[15] ;
  Stream.get( st, 15 ) ; iNumber = atoi( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; dZAR = atof( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; iCH_ad = atoi( st ) ; Stream.get() ;
  Stream.get( st, 15 ) ; iCH_vs = atoi( st ) ; Stream.get() ;
  iCH_a = iCH_ad + iCH_vs ;
  if ( ptrAdm )  delete[] ptrAdm ;
  ptrAdm = new double[iCH_a] ;
  for ( int i = 0; i < iCH_a; i++ )
   {
    Stream.get( st, 15 ) ;
    ptrAdm[i] = atof( st ) ;
    Stream.get() ;
   }

  Stream.get( st, 15 ) ; dKpr = atof( st ) ; Stream.get() ;
  Reallocate( iNumber ) ;
  for ( int iCount = 0; iCount < iNumber; iCount++ )
   {
    Stream.get( st, 15 ) ; ptrData[iCount].dTime_Norm = atof( st ) ;
     Stream.get() ;
    Stream.get( st, 15 ) ; ptrData[iCount].dCost = atof( st ) ;
     Stream.get() ;
    ptrData[iCount].dTime_Oper =
     ptrData[iCount].dTime_Norm / ( 1 + ( dAlfa + dBetta ) / 100 ) ;
   }
 }

 void TECH_PRO::Out( ostream& Stream )
 {
  Stream << iNumber << "\n" ;
  Stream << dZAR << "\n" ;
  Stream << iCH_ad << "\n" ;
  Stream << iCH_vs << "\n" ;

  for ( int i = 0; i < iCH_a; i++ )  Stream << ptrAdm[i] << "\n" ;

  Stream << dKpr << "\n" ;
  for ( int iCount = 0; iCount < iNumber; iCount++ )
   Stream << ptrData[iCount].dTime_Norm << "\n" <<
   ptrData[iCount].dCost << "\n" ;
 }

 #pragma argsused
 void TECH_PRO::WorkPlc( double dTau, double dSmen )
 {
  double dCpi ;
  int iCpi_le ;
  int iCpi_gr ;
  double dG_1 ;
  double dG_2 ;
  double dG_n ;

  iC_all = 0 ;
  dGree_mdl = 0.0 ;
  dTmp = 0.0 ;

  for ( int iCount = 0; iCount < iNumber; iCount++ )
   {
    dTmp += ptrData[iCount].dTime_Norm ;
    dCpi = ptrData[iCount].dCpi = ptrData[iCount].dTime_Oper / dTau ;

    iCpi_le = ptrData[iCount].iCpi_le = ( int ) dCpi ;
    iCpi_gr = ptrData[iCount].iCpi_gr = ( int ) ( dCpi + 1 ) ;

    dG_1 = ptrData[iCount].dGree_1 = iCpi_le ? dCpi / ( double ) iCpi_le : 0 ;
    dG_2 = ptrData[iCount].dGree_2 = iCpi_gr ? dCpi / ( double ) iCpi_gr : 0 ;

    ptrData[iCount].iCi = 0 ;
    if ( 1.0 <= dG_1 && dG_1 <= 1.1 && iCpi_le )
     ptrData[iCount].iCi = iCpi_le ;
     else
      if ( dG_1 > 1.1 || ( iCpi_le == 0 && 0.9 <= dG_2 && dG_2 < 1.0 ) )
       ptrData[iCount].iCi = iCpi_gr ;

    iC_all += ptrData[iCount].iCi ;

    dG_n = ptrData[iCount].dGree_n = ptrData[iCount].iCi ? dCpi / ( double ) ptrData[iCount].iCi : 0.0 ;

    ptrData[iCount].dGree_o =
     ( 0.9 <= dG_n && dG_n <= 1.0 ) ? dG_n : ( dG_n > 1.0 ? 1.0 : dG_n ) ;

    if ( 0.9 <= dG_n && dG_n <= 1.0 )
     ptrData[iCount].dTime_New = ptrData[iCount].dTime_Oper ;
     else
      if ( 1 < dG_n && dG_n <= 1.1 )
       ptrData[iCount].dTime_New = dTau * ptrData[iCount].iCi ;
       else  ptrData[iCount].dTime_New = 0.0 ;

    dGree_mdl += ptrData[iCount].dGree_o * ptrData[iCount].iCi ;
   }
  dGree_mdl /= ( double ) iC_all ;

  iZtt = 2 * iC_all + 1 ;
  iZnep = iZtt ;
  iCH_w = iC_all ;
  iCH_o = 1.1 * iC_all ; // * ( int ) dSmen ;

  double dDp = 0.0 ;
  int i = 0 ;
  for ( ; i < iCH_ad; i++ )  dDp += ptrAdm[i] ;
  dPktx = ( dDp * dZAR * 12.0 ) / ( double ) iCH_ad ;
  dDp = 0.0 ;
  for ( ; i < iCH_ad + iCH_vs ; i++ )  dDp += ptrAdm[i] ;
  dPktx = dPktx + ( dDp * dZAR * 12.0 ) / ( double ) iCH_vs ;
 }

 int TECH_PRO::Output( ostream& Stream, int iPageLength )
 {
  int iPl = iPageLength < 13 ? 1 : 0 ;
  int iStatus = 1 ;
  Stream << flush << endl ;

  for ( int iLength = 4, iCount = 0; iCount < iNumber; )
   {
    if ( ! iPl )  clrscr() ;

    Stream << "Ŀ" << endl ;
    Stream << " N  t.  t.   Cp    [Cp]  ]Cp[   n'  n''   C   n    n    t'. " << endl ;
    Stream << "    .  .                                     n    o    . " << endl ;
    Stream << "Ĵ" << endl ;

    Stream << setiosflags( ios::fixed ) ;
    for ( ; iCount < iNumber && ( iLength < iPageLength || iPl );
            iLength++, iCount++ )
     {
      Stream << setprecision( 2 ) ;
      Stream << setiosflags( ios::right ) ;
      if ( ptrData[iCount].dGree_n > 1 && ptrData[iCount].dGree_n <= 1.1 )
       Stream << "*" ;
       else Stream << " " ;

      Stream << setw( 2 ) << iCount + 1 << setiosflags( ios::left ) <<
                " " << setw( 5 ) << ptrData[iCount].dTime_Norm <<
                " " << setw( 5 ) << ptrData[iCount].dTime_Oper <<
                " " << setw( 5 ) << ptrData[iCount].dCpi << " " ;
      if ( ptrData[iCount].iCpi_le )
       Stream << " " << setw( 4 ) << ptrData[iCount].iCpi_le << " " ;
       else  Stream << "  --  " ;
      Stream << " " << setw( 4 ) << ptrData[iCount].iCpi_gr << " " ;
      if ( ptrData[iCount].iCpi_le )
       Stream << " " << setw( 4 ) << ptrData[iCount].dGree_1 ;
       else  Stream << "  -  " ;
      Stream << " " << setw( 4 ) << ptrData[iCount].dGree_2 ;
      if ( ptrData[iCount].iCi )
       Stream << " " << setw( 3 ) << ptrData[iCount].iCi << " " ;
       else  Stream << "  -  " ;
      Stream << " " << setw( 4 ) << ptrData[iCount].dGree_n <<
                " " << setw( 4 ) << ptrData[iCount].dGree_o ;
      if ( ptrData[iCount].iCi )
       Stream << " " << setw( 5 ) << ptrData[iCount].dTime_New << " " << endl ;
       else
        {
         Stream << " ***** " << endl ;
         iStatus = 0 ;
        }
     }

    Stream << "" << endl << endl ;

    if ( ! iPl && iCount < iNumber )
     {
      Stream << "                                --- MORE ---" ;
      iLength = 4 ;
      request() ;
     }
   }
  Stream << "  । 樥 㧪  : " << dGree_mdl << endl ;
  Stream << "  饥 ᫮ /   : " << iC_all << endl ;
  Stream << "  ᫮ .  孮᪮  ࠭ᯮ⭮  : " << iZtt << endl ;
  Stream << "  騩  . 室.  ந⢥ : " << iZnep << endl ;
  Stream << "  筠 ᫥ ࠡ : " << iCH_w << endl ;
  Stream << "   ᫥ ࠡ : " << iCH_o << endl << endl ;
  return iStatus ;
 }
 //***********************************************************************

 //***********************************************************************
 void RESULT::Clc( ostream& Stream, ENTRY_DATA& Entry, TECH_PRO& T, DATA_F& D )
 {
  Stream << "Ŀ" << endl ;
  Stream << " ⠢   ।   ७  ᫥  窠  .  .         ਡ    ⪨      ⮪   䥪  " << endl ;
  Stream << " .  ..   ..   . .   .. %  . .     ⮨.             . .    ..    . .    . .           " << endl ;
  Stream << "Ĵ" << endl ;
  do {
   //  ࢮ砫쭮 ⠢ ⠫   ⠢
   D.dKob = 0.0 ;
   for ( int iCount = 0; iCount < T.iNumber; iCount++ )
    D.dKob +=
     ( double ) T.ptrData[iCount].iCi * T.ptrData[iCount].dCost *
      ( 1 + Entry.dAlfa_t / 100.0 ) * Entry.dAlfa_of ;

   D.dKp = Entry.dAveSq * Entry.dCp * ( T.iCH_w / Entry.dSmen + T.iCH_ad + T.iCH_vs ) ;
   D.dKof = D.dKp + D.dKob ;
   D.dAsd = Entry.dPmp / 1000.0 * Entry.dN / 260.0 ;
   D.dNpz = Entry.dDpz * D.dAsd / 2.0 ;
   D.dRzor = ( Entry.dPh / 1000.0 ) / 60.0 * T.dTmp ;
   D.dNep = ( Entry.dPmp / 1000.0 + D.dRzor ) * ( double ) T.iZnep * 0.5 ;
   D.dNgi = Entry.dDgi * ( Entry.dCi / 1000.0 ) * 0.55 * Entry.dN / 260.0 ;
   D.dNop = Entry.dDop * ( Entry.dCi / 1000.0 ) * Entry.dN / 260.0 ;
   D.dKos = D.dNpz + D.dNep + D.dNgi + D.dNop ;

   D.dKpr = T.dKpr ;
   D.dKu = D.dKos + D.dKof + D.dKpr ;

   //  ७ 
   clrscr() ;
   cout << setprecision( 2 ) ;
   cout << "     ࢮ砫 ⠢ ⠫ ⠢ " << D.dKu << " . 㡫." << endl ;
   cout << "     ⠫  ᭮ ந⢥ 䮭 " << D.dKof << " . 㡫. " << endl ;
   cout << "        ।ᬮ७  ७." << endl ;
   cout << "     㤥   ७ ? []" ;
   int iArd = request() != 0xd ;
   cout << endl ;

   D.dAlfa_krl = 0.3 * dAlfa_kr ;
   D.dKs_of = 0.0 ;

   D.dKar_p = D.dKp ;
   D.dKar_ob = D.dKob ;

   D.dPar_ob = ( ( dNa_ob + D.dAlfa_krl ) / 100.0 ) * D.dKar_ob ;
   D.dPar_p = ( ( dNa_p + D.dAlfa_krl ) / 100.0 ) * D.dKar_p ;
   D.dPar = D.dPar_ob + D.dPar_p ;

   if ( iArd )  D.dKu = D.dKpr + D.dKos + D.dPar ;
    else  D.dPar = 0.0 ;

   do {
    cout << flush << setprecision( 2 ) ;
    cout << "     ⠢ ⠫ ⠢ " << D.dKu << " . 㡫." << endl ;
    cout << "     쭠 業  樨 " << dCa << " . 㡫. " << endl ;
    cout << "      ⢮ ᪠ 権 : " ;
    cin >> D.dNa ;
    D.dKu_a = D.dNa * dCa ;
   } while ( D.dKu_a > D.dKu ) ;

   //  ⥩ 樨 室
   D.dPzor = Entry.dKrz * ( Entry.dPh / 1000.0 ) / 60.0 * T.dTmp ;
   D.dPzd = D.dPzor * dAlfa_d / 100.0 ;
   D.dPsn = ( D.dPzor + D.dPzd ) * ( dAlfa_ss + dAlfa_ms + dAlfa_fz ) / 100.0 ;

   double dTop_sum = 0.0 ;
   for ( iCount = 0; iCount < T.iNumber; iCount++ )
    dTop_sum += T.ptrData[iCount].dTime_New ;
   D.dPek = ( dSmch / 1000.0 ) / 60.0 * dTop_sum ;

   D.dPam = ( dNa_ob * D.dKob ) / ( 100.0 * Entry.dN ) +
            ( dNa_p * D.dKp ) / ( 100.0 * Entry.dN ) ;

   D.dPnk = D.dPzor * dAlfa_nk / 100.0 + T.dPktx * ( 1 + dAlfa_d / 100.0 ) *
    ( 1 + ( dAlfa_ss + dAlfa_sv + dAlfa_ms + dAlfa_fz ) / 100.0 ) / Entry.dN ;

   cout << "      祭 । [.] : " ;
   cin >> D.dKred ;
   cout << "      ⠢ 業 ᫥  䮭 ࠧ : " ;
   cin >> D.dAlfa_ras ;

   D.dPkr = ( D.dKred * dAlfa_kr / 100.0 ) / Entry.dN ;
   D.dCnp = Entry.dPmp / 1000.0 + D.dPzor + D.dPzd + D.dPsn + D.dPek +
            D.dPam + D.dPnk + D.dPar + D.dPkr ;

   D.dPvp = D.dCnp * dAlfa_vp / 100.0 ;
   D.dPns = ( D.dCnp + D.dPvp ) * dAlfa_ns / 100.0 ;
   D.dPpr = ( D.dCnp + D.dPvp ) * dAlfa_pr / 100.0 ;

   D.dCn = D.dCnp + D.dPvp + D.dPpr + D.dPns ;

   //   । ਡ뫨
   D.dVr = Entry.dCi * Entry.dN / 1000.0 ;
   D.dDs = ( Entry.dCi - Entry.dPmp ) * Entry.dN / 1000.0 ;
   D.dNds = D.dDs * dAlfa_nds / 100.0 ;
   D.dPr = D.dVr - D.dCn * Entry.dN - D.dNds ;

   D.dFrez = D.dKu * dAlfa_res / 100.0 ;
   D.dFraz = D.dPr * D.dAlfa_ras / 100.0 ;

   D.dNpr = ( D.dPr - D.dFrez - D.dFraz ) * dAlfa_npr / 100.0 ;
   D.dNim = D.dKu * dAlfa_im / 100.0 ;
   D.dNb = D.dNds + D.dNpr + D.dNim ;
   D.dNm = ( D.dPr - D.dFrez - D.dFraz ) * dAlfa_mn / 100.0 ;
   D.dKR = D.dKred + D.dKred * dAlfa_kr / 100.0 ;
   D.dPrp = D.dPr - D.dNpr - D.dNim - D.dKR ;
   D.dPrp_T = D.dPr - D.dNpr - D.dNim ;
   D.dDa =  D.dNa * dCa * dAlfa_dv / 100.0 ;
   D.dPno = D.dPrp - D.dDa ;
   if ( D.dPno - D.dFrez >= 0.0 )
    {
     D.dPno -= D.dFrez ;
     if ( D.dPno - D.dFraz >= 0.0 )
      D.dPno -= D.dFraz ;
       else
        {
         D.dFraz = D.dPno ;
         D.dPno = 0.0 ;
        }
    }

   //  䥪⨢
   D.dKob_os = D.dKob * ( 1 - dNa_ob * ( double ) iLimit / 100.0 ) ;
   D.dKp_os = D.dKp * ( 1 - dNa_p * ( double ) iLimit / 100.0 ) ;

   double dEn_v = dEn_stn( iLimit ) ;
   double dD_sum = 0.0 ;
   for( int w = 2; w < iLimit; w++ )  dD_sum += 1.0 / dEn_stn( w ) ;

   if ( D.dKred > 0.0 )
    //  ।⮬
    D.dEf = ( D.dPrp + D.dPam * Entry.dN ) / ( 1.0 + dEn ) +
     ( D.dPrp_T + D.dPam * Entry.dN ) * dD_sum +
     ( D.dKob_os + D.dKp_os ) / dEn_v - ( D.dKu - D.dKR ) ;
    else
     //  ।
     D.dEf = ( D.dPrp + D.dPam * Entry.dN ) * ( dEn_v - 1.0 ) /
      ( dEn * dEn_v ) + ( D.dKob_os + D.dKp_os ) / dEn_v - D.dKu ;

   D.dEf = D.dEf < 0.0 ? - D.dEf : D.dEf ;
   if ( D.dPrp < 0.0 )  D.dEf = - D.dEf ;

   clrscr() ;

   Stream << setiosflags( ios::left ) << setprecision( 1 ) ;
   Stream << " " << setw( 9 ) << D.dKu ;
   Stream << " " ;
   if ( D.dKred > 0.0 )  Stream << setw( 9 ) << D.dKred ;
    else  Stream << "-------- " ;
   Stream << " " ;
   if ( D.dPar > 0.0 )  Stream << setw( 8 ) << D.dPar ;
    else Stream << "------- " ;
   Stream << "  " << setw( 8 ) << D.dAlfa_ras ;
   Stream << "   " ;
   Stream << setw( 8 ) << D.dVr << " " ;
   Stream << setw( 8 ) << D.dCn << " " ;
   Stream << setw( 8 ) << D.dDs << " " ;
   Stream << setw( 8 ) << D.dNds << " " ;
   if ( D.dPrp >= 0.0 )  Stream << setw( 10 ) << D.dPrp ;
    else  Stream << "--------- " ;
   Stream << " " ;
   if ( D.dPrp < 0.0 )  Stream << setw( 10 ) << ( - D.dPrp ) ;
    else  Stream << "--------- " ;
   if ( D.dPrp >= D.dDa )  Stream << " " << setw( 10 ) << D.dDa ;
    else  Stream << "  -------  " ;
   Stream << " " ;
   if ( D.dPno >= 0.0 )  Stream << setw( 8 ) << D.dPno ;
    else  Stream << "-------- " ;
   Stream << " " << setw( 9 ) << D.dEf << "" << endl ;

   cout << "   । " << D.dKred << " . 㡫. " << endl ;
   cout << "  業 ᫥  䮭 ࠧ : " << D.dAlfa_ras << endl ;
   if ( D.dPrp >= 0.0 )  cout << "  ਡ " << D.dPrp << " . 㡫. " << endl ;
    else  cout << "  ⪨ " << - D.dPrp << " . 㡫. " << endl ;
   if ( D.dPno >= 0.0 )  cout << "  । ⮪ " << D.dPno << " . 㡫. " << endl ;
   cout << "  ᪨ 䥪 : " << D.dEf << endl << endl ;
   cout << "         㤥  ࠬ ? [] " ;
  } while ( request() != 0xd ) ;
  Stream << "" << endl << endl ;
  Stream << setprecision( 2 ) ;
 }


 void RESULT::Table( ostream& Stream, ENTRY_DATA& Entry, DATA_F& D_1, DATA_F& D_2, TECH_PRO& T_1, TECH_PRO& T_2 )
 {
  Stream << endl ;
  Stream << "                    " << endl ;
  Stream << "Ŀ" << endl ;
  Stream << "                                      -.       .       " << endl ;
  Stream << "                            祭  -Ĵ" << endl ;
  Stream << "                                             ७     1          2     " << endl ;
  Stream << "Ĵ" << endl ;
  Stream << " 1.  ᫥ ࠡ,                                       " << endl ;
  Stream << "    ᥣ                                    祫  " ;
   Stream << setw( 9 ) << T_1.iCH_ad + T_1.iCH_vs + T_1.iCH_o << "  " << setw( 9 )<< T_2.iCH_ad + T_2.iCH_vs + T_2.iCH_o << " " << endl ;

  Stream << " 1.1. ⨢-ࠢ᪨                                    " << endl ;
  Stream << "      ᮭ  ᯥ樠                祫  " ;
   Stream << setw( 9 ) << T_1.iCH_ad << "  " << setw( 9 ) << T_2.iCH_ad << " " << endl ;

  Stream << " 1.2. ᭮ ந. ࠡ稥             祫  " ;
   Stream << setw( 9 ) << T_1.iCH_o << "  " << setw( 9 ) << T_2.iCH_o << " " << endl ;

  Stream << " 1.3. ᯮ⥫ ࠡ稥              祫  " ;
   Stream << setw( 9 ) << T_1.iCH_vs << "  " << setw( 9 ) << T_2.iCH_vs << " " << endl ;

  Stream << "                                                                        " << endl ;
  Stream << " 2. ⠢ ⠫, ᥣ                 .  " ;
   Stream << setprecision( 2 ) ;
   Stream << setw( 10 ) << D_1.dKu << " " << setw( 10 ) << D_2.dKu << "" << endl ;

  Stream << " 2.1. ।ந⢥ 室         .  " ;
   Stream << setw( 10 ) << D_1.dKpr << " " << setw( 10 ) << D_2.dKpr << "" << endl ;

   Stream << setprecision( 2 ) ;

  Stream << " 2.2. ᭮ ந. 䮭          .  " ;
   Stream << setw( 10 ) << D_1.dKof << " " << setw( 10 ) << D_2.dKof << "" << endl ;

  Stream << " 2.3.  ।⢠                   .  " ;
   Stream << setw( 10 ) << D_1.dKos << " " << setw( 10 ) << D_2.dKos << "" << endl ;

  Stream << "                                                                        " << endl ;
  Stream << " 3.1. ⮨  ꥬ                                     " << endl ;
  Stream << "      த樨 (  ⨧樨 )         .  " ;
   Stream << setw( 10 ) << D_1.dCn * Entry.dN << " " << setw( 10 ) << D_2.dCn * Entry.dN << "" << endl ;

  Stream << " 3.2.                                 .  " ;
   Stream << setw( 10 ) << D_1.dPns << " " << setw( 10 ) << D_2.dPns << "" << endl ;

  Stream << " 3.3.  ।                       .  " ;
   Stream << setw( 10 ) << D_1.dKR << " " << setw( 10 ) << D_2.dKR << "" << endl ;

  Stream << "                                                                        " << endl ;
  Stream << " 4.1. 窠  ॠ樨                 .  " ;
   Stream << setw( 10 ) << D_1.dVr << " " << setw( 10 ) << D_2.dVr << "" << endl ;

  Stream << " 4.2. ⨧樮 ᫥           .  " ;
   Stream << setw( 10 ) << D_1.dPam << " " << setw( 10 ) << D_2.dPam << "" << endl ;

  Stream << " 4.3. ।                                .  " ;
   Stream << setw( 10 ) << D_1.dKred << " " << setw( 10 ) << D_2.dKred << "" << endl ;

  Stream << "                                                                        " << endl ;
  Stream << " 5. ਡ,                                                 " << endl ;
  Stream << "    ᯮ殮 ।               .  " ;
   Stream << setw( 10 ) << D_1.dPrp << " " << setw( 10 ) << D_2.dPrp << "" << endl ;

  Stream << " 5.1. 믫                     .  " ;
   Stream << setw( 10 ) << D_1.dDa << " " << setw( 10 ) << D_2.dDa << "" << endl ;

  Stream << " 5.2.  䮭 १ࢠ                    १  .  " ;
   Stream << setw( 10 ) << D_1.dFrez << " " << setw( 10 ) << D_2.dFrez << "" << endl ;

  Stream << " 5.3.  䮭 ࠧ                   ࠧ  .  " ;
   Stream << setw( 10 ) << D_1.dFraz << " " << setw( 10 ) << D_2.dFraz << "" << endl ;

  Stream << " 5.4.  樠 㦤                   .  " ;
   Stream << setw( 10 ) << D_1.dPsn << " " << setw( 10 ) << D_2.dPsn << "" << endl ;

  Stream << " 5.5. 㣨 楫                          .  " ;
   Stream << setw( 10 ) << D_1.dPpr + D_1.dPvp + D_1.dPnk << " " << setw( 10 ) << D_2.dPpr + D_2.dPvp + D_2.dPnk << "" << endl ;

  Stream << " 5.6.  ⮪                    .  " ;
   Stream << setw( 10 ) << D_1.dPno << " " << setw( 10 ) << D_2.dPno << "" << endl ;

  Stream << "                                                                        " << endl ;
  Stream << " 6. 業 믫稢         %   " ;
   Stream << setw( 10 ) << dAlfa_dv << " " << setw( 10 ) << dAlfa_dv << "" << endl ;

  Stream << "                                                                        " << endl ;
  Stream << " 7. ᪨ 䥪                     .  " ;
   Stream << setw( 10 ) << D_1.dEf / 1000.0 << " " << setw( 10 ) << D_2.dEf / 1000.0 << "" << endl ;
  Stream << "" << endl ;
  Stream << setprecision( 2 ) ;
 }


 RESULT::RESULT(
  ENTRY_DATA& Entry, TECH_PRO& T_1, TECH_PRO& T_2, DATA_F& D_1, DATA_F& D_2 )
 {
  char f_name[12] ;
  ofstream f_out ;
  ofstream ff_out ;

  cout << "    室 䠩 १ : " ;
  cin.getline( f_name, 12 ) ;
  f_out.open( f_name ) ;

  cout << "    室 䠩 : " ;
  cin.getline( f_name, 12 ) ;
  ifstream f_in ;
  f_in.open( f_name, ios::binary ) ;

  if ( ! f_out )
   {
    cerr << " Cannot open output file" ;
    return ;
   }

  if ( ! f_in )
   {
    ff_out.open( f_name, ios::binary ) ;
    if ( ! ff_out )  return ;
    cout << "         " << f_name ;
    request() ;
   }

  if ( ! f_in )
   {
    Entry.Input( cin ) ;
    Entry.Out( ff_out ) ;
   }
   else
    if ( ! Entry.Input( f_in ) )
     {
      cout << "   DATA FILE CORRUPED ! " ;
      return ;
     }

  clrscr() ;

  //   䮭 ࠡ祣 ६
  dFn = dTsm * dD * Entry.dSmen ;

  //  ⥫쭮 뢮 
  dTn = d_tn * dD * Entry.dSmen ;

  //  ⨢ ६ ࠡ  ᡮન
  dFop = dFn - dTn ;

  //  ⠪ ᪠ 
  dTau_v = dFop / Entry.dN ;

  //  ⠪  ᡮન
  dTau = 1.0 * dTau_v ;

  int iCorr = 1 ;
  int iStt ;

  do {
   clrscr() ;
   cout << endl << "      ࠬ  ᡮન  ࢮ . . " << endl << endl ;
   if ( ! f_in )
    {
     f_out << endl << "      ࠬ  ᡮન  ࢮ . . " << endl << endl ;
     T_1.Input( cin ) ;
     if ( iCorr )  T_1.Out( ff_out ) ;
    }
    else
     if ( iCorr )  T_1.Input( f_in ) ;
      else
       {
        f_out << endl << "      ࠬ  ᡮન  ࢮ . . " << endl << endl ;
        T_1.Input( cin ) ;
       }

   //  ᫠ ࠡ    樨
   T_1.WorkPlc( dTau, Entry.dSmen ) ;

   clrscr() ;
   iStt = T_1.Output( cout, 22 ) ;
   T_1.Output( f_out, 0 ) ;
   if ( iStt )
    cout << endl << "               㤥 ந ४ ? [] " ;
    else
     cout << endl << "               室 ४,   " ;
   iCorr = 0 ;
  } while ( request() != 0xd || ! iStt ) ;

  // 䨭ᮢ ᭮ ࢮ 孮᪮ 
  f_out << endl << "          " << endl << endl ;
  Clc( f_out, Entry, T_1, D_1 ) ;

  iCorr = 1 ;
  do {
   clrscr() ;
   cout << endl << "      ࠬ  ᡮન  ஬ . . " << endl << endl ;
   if ( ! f_in )
    {
     f_out << endl << "      ࠬ  ᡮન  ஬ . . " << endl << endl ;
     T_2.Input( cin ) ;
     if ( iCorr )  T_2.Out( ff_out ) ;
    }
    else
     if ( iCorr )  T_2.Input( f_in ) ;
      else
       {
        f_out << endl << "      ࠬ  ᡮન  ஬ . . " << endl << endl ;
        T_2.Input( cin ) ;
       }

   //  ᫠ ࠡ    樨
   T_2.WorkPlc( dTau, Entry.dSmen ) ;
   clrscr() ;
   iStt = T_2.Output( cout, 22 ) ;
   T_2.Output( f_out, 0 ) ;
   if ( iStt )
    cout << endl << "               㤥 ந ४ ? [] " ;
    else
     cout << endl << "               室 ४,   " ;
   iCorr = 0 ;
  }  while ( request() != 0xd || ! iStt ) ;

  ff_out.close() ;

  // 䨭ᮢ ᭮ ࢮ 孮᪮ 
  f_out << endl << "          " << endl << endl ;
  Clc( f_out, Entry, T_2, D_2 ) ;

  Table( f_out, Entry, D_1, D_2, T_1, T_2 ) ;

  clrscr() ;
  cout << "            " ;
  if ( D_1.dEf >= D_2.dEf )
   cout << "   " ;
   else  cout << "   " ;
  cout << endl << "                          ";
  request() ;
  clrscr() ;
  f_out << endl << endl << "        " ;
  if ( D_1.dEf >= D_2.dEf )
   f_out << "   " ;
   else  f_out << "   " ;
  f_out << endl ;
  if ( D_1.dEf >= D_2.dEf )  CalcTS( &Entry, &T_1, this, f_out ) ;
   else  CalcTS( &Entry, &T_2, this, f_out ) ;

  f_out.close() ;
  clrscr() ;
 }
 //*************************************************************************

 main()
 {
  ENTRY_DATA EntryData ;
  TECH_PRO Tpr_1 ;
  TECH_PRO Tpr_2 ;
  DATA_F D_1 ;
  DATA_F D_2 ;

  cputs( "\n\r       Dec. 1993   Satur ventur non studit libentur  ltd.   " ) ;
  delay( 700 ) ;
  clrscr() ;

  RESULT Result( EntryData, Tpr_1, Tpr_2, D_1, D_2 ) ;

  return 5 ;
 }

 int NOK( int n, int* v )
 {
  int numbers = n ;
  int nok = 1 ;
  while ( nok++ )
   {
    for ( int i = 0; i < numbers ; i++ )
     {
      int Ci = v[i] ;
      if ( ( ( ( double ) nok / ( double ) Ci ) -
       ( ( double ) ( nok / Ci ) ) ) != 0.0 )
       goto uu;
     }
    break ;
uu:
   }
  return nok ;
 }

 class GREATE_EXECUTOR
 {
  protected :
   double Takt() ;
   int NOK_Ci() ;
   void TestUp() ;
   int OutResult( ostream& ostr, int qw = 0 ) ;

  public :
   ENTRY_DATA *ED ;
   TECH_PRO   *TP ;
   RESULT     *R ;
   void Mark( istream& IStr,ostream& OStr ) ;

   char Msg[256] ;
   int  q ; //.⭮ 
   int  C ; //饥 - ࠡ 
   double  Lp ; // ࠡ祩  
   double  Lns ; //  
   double  Lm ; //㦥  
   double  Ln ; //⥫쭠  
   double  l ; //ﭨ  
   double  Up ; // ᪮  
   double  e ; //⫨稥 Ln  Ln'
   double  s ;
   int  d ;
   int  n0 ; // 饥 ᫮ ﭨ ࠡ 
   double tau ; // ⠪
   double T0 ; //ਮ 

   GREATE_EXECUTOR( ENTRY_DATA *ed, TECH_PRO *tp, RESULT *r, ostream &ostr) ;
 }; /* class GREAT_EXECUTOR */

 class MARK_INFO
 {
  public :
   int  num ; //᫮ 権
   int  nums ;
   int  n ; // info[i]
   int *info ; //ᨢ 権
   int *Ci ;
   int *table_item ;

   void Input( int col, istream& istr, ostream& ostrm, TECH_PRO* ) ;
   MARK_INFO(){num=0;info=0;table_item=0;}
   ~MARK_INFO(){delete info;delete table_item;delete Ci;}
 }; /* class MARK_INFO */

 static int check_info[] = {0,0,0,0,0,0,0,0,0,0};
 static int iNum_operations;

 #pragma argsused
 void MARK_INFO::Input( int col, istream& istr, ostream& ostr, TECH_PRO* TP )
 {
  cout << endl << endl ;
  int bError=0;
  do
   {
    cout << "  ⢮ 権  " << col+1 << " e ࠧ⪨ : " ;
    cin >> num ;
    bError = (num<0)||(num>iNum_operations);
    if (bError) cout << " 訡 !!!\7"<<endl;
   }   while (bError);

  info=new int[num] ;
  Ci=new int[num];
  for ( int j = 0; j < num; j++ )
   {
    cout << "  " << j+1 << "  樨  " << col+1 << " e ࠧ⪨ : " ;
    cin >> info[j] ;
    if (info[j]<0 || info[j]>TP->iNumber || check_info[info[j]-1])
     {
      cout << " 訡 !!!\7"<<endl;
      bError = 1;
      j--;
      continue;
     }
    else
     { bError = 0;
       iNum_operations--;
       check_info[info[j]-1] = 1;
     }
    Ci[j] = TP->ptrData[info[j]-1].iCi ;
   }
  n = NOK( num, Ci ) ;
 }

 class MARKS
 {
  public :
   int nCol ; //᫮ 冷
   int max;
   MARK_INFO *mi ;
   TECH_PRO *TP ;

   void Out( ostream& ) ;
   void OutTable( ostream&, GREATE_EXECUTOR* ) ;
   MARKS( istream& istr, ostream& ostr, TECH_PRO* ) ;
   ~MARKS() { delete mi ; }
 }; /* class MARKS */

 void MARKS::Out( ostream& ostr )
 {
  int i,j;
  ostr << endl << endl << endl;
  ostr << "                      P" << endl;
  ostr << "     " ;
  for ( i = 0; i < max; i++ )
   {
    if ( ! i )  ostr << "" ;
    ostr << "" ;
    if ( i == max - 1 )  ostr << "" ;
     else  ostr << "" ;
   }
  ostr << endl ;
  for ( i = 0; i < nCol; i++ )
   {
    if (i)
     {
      ostr << "     " ;
      for ( int k = 0; k < max; k++ )
       {
        if ( k == 0 ) ostr << "" ;
        ostr << "" ;
        if ( k == max - 1 )  ostr << "" ;
         else  ostr << "" ;
       }
      ostr << endl ;
     }
    ostr << " " << setw( 2 ) << i + 1 << "   " ;
    for ( j = 0; j < max; j++ )
     ostr << setw( 2 ) << mi[i].table_item[j] << "  " ;
    ostr << endl ;
   }
  ostr << "     " ;
  for ( i = 0; i < max; i++ )
   {
    if ( i == 0 )  ostr << "" ;
    ostr << "" ;
    if ( i == max - 1 )  ostr << "" ;
     else  ostr << "" ;
   }
  ostr << endl ;
 }

 void MARKS::OutTable( ostream& ostr, GREATE_EXECUTOR* GP )
 {
  int nrm = 1 ;
  int nop = 1 ;
  ostr << endl << endl <<"            ९ ஢ ࠧ⪨  " << endl ;
  ostr << "Ŀ" << endl ;
  ostr << " N .  N .  N .              ࠧ          " << endl ;
  ostr << "Ĵ" << endl ;
  for ( nop = 1; nop <= GP->TP->iNumber; nop++ )
   {
    if (nop!=1) ostr << "Ĵ" << endl ;
    DATA_STR *Data = &( GP->TP->ptrData[nop-1] ) ;
    int nrmo = Data->iCi ;
    int col ; // 鸞  樨
    for ( int k = 0; k < nCol; k++ )
     for ( int t = 0; t < mi[k].num; t++ )
      if ( nop == mi[k].info[t] )  { col = k; goto ccc; }
    ccc:
    ostr << " " << setw( 5 ) << nop << "  " << setw( 5 ) << col+1 << " " ;
    for ( int j = 0; j < nrmo; j++ )
     {
      if (j)  ostr << "              " ;
      ostr << " " << setw( 5 ) << nrm << "  " ;
      int iLP ;
      for ( k = 0, iLP = 0; k < mi[col].n; k+=nrmo, iLP++ )
       {
        if ( k )  ostr << "," ;
        ostr << setw( 2 ) << mi[col].table_item[max-k-1-j] ;
       }
      for ( iLP = 45 - ( iLP * 3 - 1 ); iLP; iLP-- )  ostr << " " ;
      ostr << "" << endl ;
      nrm++ ;
     }
   }
  ostr << "" << endl ;
 }

 MARKS::MARKS( istream& istr, ostream& ostr, TECH_PRO* tp )
 {
  TP = tp ;
  do {
   clrscr() ;
   cout << " Ŀ" << endl ;
   cout << "  N .  ᫮ ࠡ  " << endl ;
   cout << " Ĵ" << endl ;
   for ( int i = 0; i < tp->iNumber; i++ )
    cout << "  " << setw( 5 ) << i + 1 << "       "
     << setw( 8 ) << tp->ptrData[i].iCi << "      " << endl ;
   cout << " " << endl << endl ;

   cout << "  ⢮ 冷 ࠧ⪨ : " ;
   cin >> nCol ;
   mi = new MARK_INFO[nCol] ;
   max = 0 ;
   setmem(check_info,sizeof(int)*10,0x0); ;
   iNum_operations=tp->iNumber;
   for ( i = 0; i < nCol; i++ )  mi[i].Input( i, istr, ostr, TP) ;
   if (iNum_operations) cout << " 訡 !!!\7 " << endl << endl ;
  } while ( iNum_operations ) ;

  for ( int i = 0; i < nCol; i++ )
   if ( mi[i].n > max )  max = mi[i].n ;

  for ( i = 0; i < nCol; i++ )
   {
    mi[i].table_item = new int[max] ;
    int index = 0 ;
    for ( int j = 0; j < max; j++ )
     {
      mi[i].table_item[max-1-j] = (++index) ;
      if ( index >= mi[i].n )  index = 0 ;
     }
   }
 }

 void GREATE_EXECUTOR::Mark( istream& istr, ostream& ostr )
 {
  MARKS *MM = new MARKS( istr, ostr, TP ) ;
  MM->Out(cout);
  do {
   cout <<"\n    ? []";
   if ( request() != 0xd )
    {
     delete MM ;
     MM = new MARKS( istr, ostr, TP ) ;
     MM->Out(cout);
     continue ;
    }
   break ;
  } while ( 1 ) ;
  MM->Out(ostr);

  MM->OutTable( ostr, this ) ;
 }

 int GREATE_EXECUTOR::OutResult( ostream& ostr, int qw )
 {
  clrscr();
  ostr << "\n  롮 ࠭ᯮ ।  ஢  \n" ;
  ostr << "\n  .⭮                     q = " << setw( 7 ) << q;
  ostr << "\n  饥 - ࠡ                     C = " << setw( 7 ) << C;
  ostr << "\n   ࠡ祩                 Lp = " << setw( 7 ) << Lp << " ." ;
  ostr << "\n                         Ln' = " << setw( 7 ) << Lns << " ." ;
  ostr << "\n  㦥                     Lm = " << setw( 7 ) << Lm << " ." ;
  ostr << "\n  ⥫쭠        Ln = " << setw( 7 ) << Ln << " ." ;
  ostr << "\n  ⫨稥                            Ln  Ln' " << setw( 7 ) << (e*100) << " %." ;
  ostr << "\n  ﭨ                        l = " << setw( 7 ) << l << " ." ;
  ostr << "\n  ᪮                Up = " << setw( 7 ) << Up << " /." ;
  ostr << "\n   蠣                          s = " << setw( 7 ) << s << " ." ;
  ostr << "\n  楫 ᫮ 蠣  ࠡ稬 ⠬ d = " << setw( 7 ) << d << " ." ;
  ostr << "\n  饥 ᫮ ﭨ ࠡ祣     n0 = " << setw( 7 ) << n0 ;
  ostr << "\n  ਮ                           T0 = " << setw( 7 ) << T0 << " ." ;
  ostr << "\n  ⠪ 筮                     tau = " << setw( 7 ) << tau << " ." << endl;
  if (qw)
   {
    cout <<"\n\n    ? []";
    return request() == 0xd ;
   }
  return 1 ;
 }


 GREATE_EXECUTOR::GREATE_EXECUTOR(
  ENTRY_DATA *ed, TECH_PRO *tp, RESULT *r, ostream& ostr )
 {
  ED=ed;TP=tp;R=r;Takt();NOK_Ci();T0=n0*tau;
  contin:
  cout << "\n   蠣 s [] " ;
   cin >> s ;
  cout << "\n  ᫮ 蠣   ࠡ稬 ⠬ d : " ;
   cin >> d ;
  if (d==0 || s==0.0) goto contin;
  Up = s/tau;  Up = s/tau;TestUp();
  l=s*d;
  C=0;
  for (int i=0;i<TP->iNumber;i++)
   {C+=TP->ptrData[i].iCi;
    TP->ptrData[i].li=s*TP->ptrData[i].iCi;
   }
  Lp=l*(C+1);
  Lm=2.5;
  Lns=2*Lp+Lm;
  q= ((2*Lp+Lm)/(s*n0)+0.5);
  Ln=q*s*n0;
  e = (Ln-Lns)/Ln;e= (e<0) ? -e : e;
  Lp=(Ln-Lm)/2;
  l=Lp/(C+1);
  s=l/d;
  Up = s/tau;TestUp();
  if (!OutResult(cout,1)) goto contin;
  OutResult(ostr);
  Mark(cin,ostr);
 }

 void GREATE_EXECUTOR::TestUp()
 {
  if (Up<0.1) strcpy(Msg,"  饥  " ) ;
  else if (Up>5) strcpy(Msg," 誮 ஥  ") ;
  else strcpy(Msg,"  뢭  ") ;
 }

 double GREATE_EXECUTOR::Takt() { return  tau=R->dTau ; }

 int GREATE_EXECUTOR::NOK_Ci() //襥 饥 ⭮
 {
  int numbers=TP->iNumber;
  int nok=1;
  while (nok++)
   {
    for (int i=0;i<numbers;i++)
     {
      int Ci=TP->ptrData[i].iCi;
      if ( (((double)nok/(double)Ci) - ((double)(nok/Ci))) != 0.0)
       goto inc;
     }
    break;
inc:;
   }
   return n0=nok;
 }

 void CalcTS(ENTRY_DATA *ed,TECH_PRO *tp,RESULT *r,ostream &ostr)
 {
  clrscr();
  GREATE_EXECUTOR(ed,tp,r,ostr);
  ostr << " Ŀ" << endl ;
  ostr << "  N .  ᫮ ࠡ  ᫮ ⠪⮢" << endl ;
  ostr << " Ĵ" << endl ;
  for ( int i = 0; i < tp->iNumber; i++ )
    ostr << "  " << setw( 5 ) << i + 1 << "       " << setw( 8 ) << tp->ptrData[i].iCi << "      "
            "     " << setw( 6 ) << (tp->ptrData[i].dTime_New/r->dTau) <<
            " " << endl ;
  ostr << " " << endl << endl ;

 }

