Uses Crt,Dos,FileUnit;

Var List,FLog                   : text;
    lptr                        : longint;
    DirInfo                     : SearchRec;
    dirnum                      : string[2];
    diz,s2,s3                   : string;
    Spath,Inpath,NotFound,Dupes : String;
    ListName                    : String;
    Mask                        : String[12];
    Log                         : Boolean;
    LogName,DupeInfoName,DescFileName  : String;
    Year,Month,Day,DayOfWeek    : Word;
    Hour,Minute,Second,Sec100   : Word;

 Procedure AddLog(S:String);
  Begin
   If Log Then Writeln(FLog,s);
  End;

 Procedure StartLog(LName:String);
  Begin
   If Log Then
    Begin
     Assign(FLog,LName);
     If ProvFile(LName) then Append(FLog) Else Rewrite(FLog);
     GetDate(Year,Month,Day,DayOfWeek);
     GetTime(Hour,Minute,Second,Sec100);
     Writeln(FLog);
     Writeln(FLog,'! RefToss Session Started ',Day,'/',Month,'/',Year,',',Hour,':',Minute,':',second,'.');
     Writeln(FLog);
    End;
  End;
 Procedure CloseLog;
  Begin
   If Log Then
    Begin
     Writeln(FLog,'! RefToss Done');
     Writeln(FLog);
     Close(FLog);
    End;
  End;

 Procedure RDConfig;
  Var TCon : Text;
      TStr : String;

  Procedure ErrHndl(i:Byte);
   Const Errs : Array[1..6] of string[50] =
    ('! Configuration file contains ERRORS !',
     '! Base path not defined !',
     '! Inbound path not defined !',
     '! Path for unknown files not defined !',
     '! Path for dupes not found !',
     '! Configuration file not found !');
   Begin
    Writeln;
    TextColor(Red);
    Writeln(Errs[i]);
    Writeln('! RTFM !');
    TextColor(LightGray);
    Writeln;
    Halt;
   End;

  Function ExtractValue(s:String):String;
   Var ss:String;
   Begin
    ss:=s;
    If pos('=',ss)=0 Then ErrHndl(1);
    Delete(ss,1,pos('=',ss));
    If pos(';',ss)<>0 then Delete(ss,pos(';',ss),length(ss)-pos(';',ss)+1);
    ExtractValue:=ss;
   End;
  Function ExtractPath(s:String):String;
   Var ss:String;
   Begin
    ss:=extractvalue(s);
    If ss[length(ss)]<>'\' then ss:=ss+'\';
    Extractpath:=ss;
   End;

  Procedure Parser(ss:string);
   Var KWPtr : Byte;
       SUp   : String;
       yess  : String[3];
   Const
        KCoun  = 10;
        KWords : Array[1..KCoun] of string[14] =
   ('#REFBASE','#INBOUND','#UNKNOWN','#DUPES','#FILEMASK','#LISTNAME',
    '#LOG','#LOGNAME','#DUPEINFONAME','#DESCFILENAME');
   Begin
    SUp:=UpperCase(ss);
    If pos(';',SUp)<>0 then Delete(SUp,pos(';',SUp),length(SUp)-pos(';',SUp)+1);
    If SUp='' then Exit;

    For KWPtr:=1 to KCoun do
     If pos(KWords[KWPtr],SUp)<>0 then
       Case KWPtr Of
        1:  SPath:=ExtractPath(SUp);
        2:  InPath:=ExtractPath(SUp);
        3:  NotFound:=ExtractPath(SUp);
        4:  Dupes:=ExtractPath(SUp);
        5:  Mask:=ExtractValue(SUp);
        6:  ListName:=ExtractValue(SUp);
        7:  Begin
             yess:=ExtractValue(SUp);
             If yess='YES' then Log:=True;
             If yess='NO' then Log:=False;
            End;
        8:  LogName:=ExtractValue(SUp);
        9:  DupeInfoName:=ExtractValue(SUp);
        10: DescFileName:=ExtractValue(SUp);
       End;
   End;

  Begin
   If Not ProvFile('RefToss.Ctl') Then ErrHndl(6);

   SPath:='';InPath:='';NotFound:='';Dupes:='';Mask:='*.*';
   ListName:='REFERATS.LST';Log:=False;LogName:='REFTOSS.LOG';
   DupeInfoName:='FILES.BBS';DescFileName:='FILES.BBS';

   Assign(TCon,'RefToss.Ctl');Reset(TCon);
    While Not(Eof(TCon)) do
     Begin
      Readln(TCon,TStr);
      If TStr<>'' Then Parser(TStr);
     End;
   Close(TCon);

   If SPath=''    then ErrHndl(2) Else Writeln('BasePath           = ',Spath);
   If InPath=''   then ErrHndl(3) Else Writeln('InBound            = ',InPath);
   If NotFound='' then ErrHndl(4) Else Writeln('Unknown            = ',NotFound);
   If Dupes=''    then ErrHndl(5) Else Writeln('DupePath           = ',Dupes);

   Writeln('Archive Mask       = ',mask);
   Writeln('List Name          = ',listname);
   If Log Then
    Begin
     Writeln('! Log Opened !');
     Writeln('Log Name           = ',LogName);
    End;
   Writeln('Dupe Information   = ',DupeInfoName);
   Writeln('Description files  = ',DescFileName);
  End;

 Procedure SeekInRefList(name:string);
  Var ss   : string;
      fbbs : text;
      nam  : string;
      sear : string;
  Begin
   nam:=uppercase(name);
   Reset(list);
   While not eof(list) do
    Begin
    Readln(list,ss);
     if pos('[',ss)<>0 then
      if (ss[pos('[',ss)+1] in ['0'..'9']) and (ss[pos('[',ss)+2] in ['0'..'9']) then
       if ss[pos('[',ss)+3]=']' then
         Begin
          dirnum:=copy(ss,pos('[',ss)+1,2);
          gotoxy(1,wherey); write('section : ',dirnum);
         End;

     if ss<>'' then sear:=Uppercase(copy(ss,1,pos(' ',ss)-1)) else sear:='';
     gotoxy(20,wherey);write(sear,'             ');

     if ((nam=sear)) and (not(provfile(spath+dirnum+'\'+name))) then
      Begin
       writeln;
       writeln('adding description for file ',name,' to ','..\'+dirnum+'\files.bbs');
       AddLog('adding description for file '+name+' to '+'..\'+dirnum+'\files.bbs');
       assign(fbbs,spath+dirnum+'\'+descfilename);
       if provfile(spath+dirnum+'\'+descfilename) then append(fbbs) else
        Begin
         MkDir(spath+dirnum);
         rewrite(fbbs);
         writeln('! ',descfilename,' file successfully created !');
         AddLog('! '+descfilename+' file successfully created !');
        End;
       writeln(fbbs,ss);
       readln(list,ss);
       while pos('       ',ss)=1 do
        Begin
         writeln(fbbs,ss);
         readln(list,ss);
        End;
       close(fbbs);
       MoveFile(inpath+name,spath+dirnum+'\'+name);
       writeln('moving : ',inpath+name,' --> ',spath+dirnum+'\'+name);
       AddLog('moving : '+inpath+name+' --> '+spath+dirnum+'\'+name);
       AddLog('');
       exit;
      End;
    if ((nam=sear)) and (provfile(spath+dirnum+'\'+name)) then
     Begin
      gotoxy(1,wherey);
      Writeln('! File "',nam,'" exists in ',spath+dirnum+'\',' !     ');
      AddLog('! File "'+nam+'" exists in '+spath+dirnum+'\'+' !');
      Writeln('moving : ',name,' --> ',Dupes+name);
      AddLog('moving : '+name+' --> '+Dupes+name);
      MoveFile(inpath+name,Dupes+name);
      assign(fbbs,dupes+dupeinfoname);
       if provfile(dupes+dupeinfoname) then append(fbbs) else
        Begin
         rewrite(fbbs);
         writeln('! ',dupeinfoname,' file successfully created !');
         AddLog('! '+dupeinfoname+' file successfully created !');
        End;
       writeln(fbbs,spath+dirnum+'\');
       writeln(fbbs,ss);
       readln(list,ss);
       while pos('       ',ss)=1 do
        Begin
         writeln(fbbs,ss);
         readln(list,ss);
        End;
       Writeln(fbbs);
       close(fbbs);
       AddLog('');
       Exit;
     End;
    End;
   gotoxy(1,wherey);Writeln('! File "',nam,'" from unknown section !     ');
   AddLog('! File "'+nam+'" from unknown section !');
   Writeln('moving : ',name,' --> ',NotFound+name);
   AddLog('moving : '+name+' --> '+NotFound+name);
   AddLog('');
   MoveFile(inpath+name,NotFound+name);
  End;

Var ch : Char;

Begin
 TextColor(LightGreen);
 Writeln;Writeln('REFTOSS v2.2. Copyright (c) 1997, Tony Pavlov. 2:5020/1098.0@Fidonet');
 TextColor(LightGray);
 Writeln;
 Writeln('Configuration settings :');
 RdConfig;
 Writeln;
 StartLog(LogName);
 If provfile(ListName) then
  Begin
   assign(list,ListName);Reset(list);
  End Else
  Begin
   Writeln;
   Writeln('! File List ',ListName,' not found !');
   AddLog('! File List '+ListName+' not found !');
   CloseLog;
   halt;
  End;

 FindFirst(inpath+mask,archive,dirinfo);
  If DosError=0 then
   While DosError=0 do
    Begin
     Writeln('Seek for file : ',DirInfo.name);
     SeekInRefList(DirInfo.Name);
     FindNext(dirinfo);
     Writeln;
    End Else
    Begin
     Writeln('! No Files in ',InPath,' !');
     AddLog('! No Files in '+InPath+' !');
    End;
 Close(list);
 CloseLog;
 Writeln('Done !');
End.